/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.tdc_client.services;

import com.sc.sicanet.tdc_client.entities.CatAlias;
import com.sc.sicanet.tdc_client.entities.PrestamosTdc;
import com.sc.sicanet.tdc_client.repositories.PrestamosTdcRepository;
import com.sc.sicanet.tdc_client.services.PrestamosTdcService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PrestamosTdcServiceimpl
implements PrestamosTdcService {
    @PersistenceContext
    private EntityManager entityManager;
    private final PrestamosTdcRepository repository;

    public PrestamosTdcServiceimpl(PrestamosTdcRepository repository) {
        this.repository = repository;
    }

    public List<PrestamosTdc> findAll() {
        return (List)this.repository.findAll();
    }

    public Optional<PrestamosTdc> findById(int id) {
        return this.repository.findById((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<PrestamosTdc> findByCuentaSTP(String cuentaSTP) {
        try {
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(PrestamosTdc.class);
            Root alias = query.from(CatAlias.class);
            Join prestamos = alias.join("prestamosTdc", JoinType.INNER);
            Predicate predicate = cb.equal((Expression)prestamos.get("cuentaStp"), (Object)cuentaSTP);
            query.multiselect(new Selection[]{alias.get("accountId").alias("account_id"), prestamos.get("pkPrestamosTdc").alias("pkPrestamosTdc")}).where((Expression)predicate);
            Optional<PrestamosTdc> prestamo = Optional.ofNullable((PrestamosTdc)this.entityManager.createQuery(query).setMaxResults(1).getSingleResult());
            System.out.println("prestamo -> " + prestamo.get().getAccount_id());
            Optional<PrestamosTdc> optional = prestamo;
            return optional;
        }
        catch (Exception e) {
            System.out.println("Error: " + String.valueOf(e));
            this.entityManager.close();
            Optional<PrestamosTdc> optional = Optional.empty();
            return optional;
        }
        finally {
            this.entityManager.close();
        }
    }
}

