/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.stp_ws.services;

import com.sc.sicanet.stp_ws.models.Dispersion;
import com.sc.sicanet.stp_ws.services.DispersionService;
import com.sc.sicanet.stp_ws.services.STPService;
import com.sc.sicanet.stp_ws.utils.CryptoHanler;
import java.math.BigDecimal;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DispersionServiceImpl
implements DispersionService {
    @Value(value="${config.crypto.alias}")
    private String alias;
    @Value(value="${config.crypto.password}")
    private String password;
    final STPService stpService;

    public DispersionServiceImpl(STPService stpService) {
        this.stpService = stpService;
    }

    public Optional<Object> putDispersion(String entity) {
        CryptoHanler cryptoHanler = new CryptoHanler();
        try {
            Dispersion dispersion = this.buildDispersion();
            String cadenaOriginal = this.buildCadenaOriginal(dispersion);
            String firma = cryptoHanler.sign(cadenaOriginal, this.password, this.alias);
            dispersion.setFirma(firma);
            return this.stpService.putDispersion(dispersion);
        }
        catch (Exception e) {
            System.out.println("e -> " + e.getMessage());
            return null;
        }
    }

    private Dispersion buildDispersion() {
        Dispersion dispersionWS = new Dispersion();
        dispersionWS.setEmpresa("STP");
        dispersionWS.setMonto(new BigDecimal("0.01"));
        dispersionWS.setInstitucionContraparte(Integer.valueOf(97846));
        dispersionWS.setClaveRastreo("Ras00002");
        dispersionWS.setReferenciaNumerica(Integer.valueOf(1234567));
        dispersionWS.setNombreBeneficiario("Eduardo");
        dispersionWS.setConceptoPago("Pago de prueba");
        dispersionWS.setCuentaBeneficiario("846180000400000001");
        dispersionWS.setTipoCuentaBeneficiario(Integer.valueOf(40));
        dispersionWS.setTipoPago(Integer.valueOf(1));
        dispersionWS.setCuentaOrdenante("646180110400000007");
        dispersionWS.setTipoCuentaOrdenante(Integer.valueOf(40));
        dispersionWS.setRfcCurpBeneficiario("ND");
        dispersionWS.setInstitucionOperante(Integer.valueOf(90646));
        return dispersionWS;
    }

    private String buildCadenaOriginal(Dispersion dispersion) {
        StringBuilder sB = new StringBuilder();
        sB.append("||");
        sB.append(dispersion.getInstitucionContraparte()).append("|");
        sB.append(dispersion.getEmpresa()).append("|");
        sB.append(dispersion.getFechaOperacion() == null ? "" : dispersion.getFechaOperacion()).append("|");
        sB.append(dispersion.getFolioOrigen() == null ? "" : dispersion.getFolioOrigen()).append("|");
        sB.append(dispersion.getClaveRastreo() == null ? "" : dispersion.getClaveRastreo()).append("|");
        sB.append(dispersion.getInstitucionOperante() == null ? "" : dispersion.getInstitucionOperante()).append("|");
        sB.append(dispersion.getMonto() == null ? "" : dispersion.getMonto()).append("|");
        sB.append(dispersion.getTipoPago() == null ? "" : dispersion.getTipoPago()).append("|");
        sB.append(dispersion.getTipoCuentaOrdenante() == null ? "" : dispersion.getTipoCuentaOrdenante()).append("|");
        sB.append(dispersion.getNombreOrdenante() == null ? "" : dispersion.getNombreOrdenante()).append("|");
        sB.append(dispersion.getCuentaOrdenante() == null ? "" : dispersion.getCuentaOrdenante()).append("|");
        sB.append(dispersion.getRfcCurpOrdenante() == null ? "" : dispersion.getRfcCurpOrdenante()).append("|");
        sB.append(dispersion.getTipoCuentaBeneficiario() == null ? "" : dispersion.getTipoCuentaBeneficiario()).append("|");
        sB.append(dispersion.getNombreBeneficiario() == null ? "" : dispersion.getNombreBeneficiario()).append("|");
        sB.append(dispersion.getCuentaBeneficiario() == null ? "" : dispersion.getCuentaBeneficiario()).append("|");
        sB.append(dispersion.getRfcCurpBeneficiario() == null ? "" : dispersion.getRfcCurpBeneficiario()).append("|");
        sB.append(dispersion.getEmailBeneficiario() == null ? "" : dispersion.getEmailBeneficiario()).append("|");
        sB.append(dispersion.getTipoCuentaBeneficiario2() == null ? "" : dispersion.getTipoCuentaBeneficiario2()).append("|");
        sB.append(dispersion.getNombreBeneficiario2() == null ? "" : dispersion.getNombreBeneficiario2()).append("|");
        sB.append(dispersion.getCuentaBeneficiario2() == null ? "" : dispersion.getCuentaBeneficiario2()).append("|");
        sB.append(dispersion.getRfcCurpBeneficiario2() == null ? "" : dispersion.getRfcCurpBeneficiario2()).append("|");
        sB.append(dispersion.getConceptoPago() == null ? "" : dispersion.getConceptoPago()).append("|");
        sB.append(dispersion.getConceptoPago2() == null ? "" : dispersion.getConceptoPago2()).append("|");
        sB.append(dispersion.getClaveCatUsuario1() == null ? "" : dispersion.getClaveCatUsuario1()).append("|");
        sB.append(dispersion.getClaveCatUsuario2() == null ? "" : dispersion.getClaveCatUsuario2()).append("|");
        sB.append(dispersion.getClavePago() == null ? "" : dispersion.getClavePago()).append("|");
        sB.append(dispersion.getReferenciaCobranza() == null ? "" : dispersion.getReferenciaCobranza()).append("|");
        sB.append(dispersion.getReferenciaNumerica() == null ? "" : dispersion.getReferenciaNumerica()).append("|");
        sB.append(dispersion.getTipoOperacion() == null ? "" : dispersion.getTipoOperacion()).append("|");
        sB.append(dispersion.getTopologia() == null ? "" : dispersion.getTopologia()).append("|");
        sB.append(dispersion.getUsuario() == null ? "" : dispersion.getUsuario()).append("|");
        sB.append(dispersion.getMedioEntrega() == null ? "" : dispersion.getMedioEntrega()).append("|");
        sB.append(dispersion.getPrioridad() == null ? "" : dispersion.getPrioridad()).append("|");
        sB.append(dispersion.getIva() == null ? "" : dispersion.getIva()).append("||");
        String cadena = sB.toString();
        System.out.println("Cadena original: " + cadena);
        return cadena;
    }
}

