/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.stp_ws.services;

import com.sc.sicanet.stp_ws.clients.ApiTDCFeignClient;
import com.sc.sicanet.stp_ws.clients.PrestamosFeignClient;
import com.sc.sicanet.stp_ws.clients.PrestamosTdcFeignClient;
import com.sc.sicanet.stp_ws.dto.AbonoRequestDTO;
import com.sc.sicanet.stp_ws.dto.AbonoResponseDTO;
import com.sc.sicanet.stp_ws.dto.AuthRequestDTO;
import com.sc.sicanet.stp_ws.dto.AuthResponseDTO;
import com.sc.sicanet.stp_ws.dto.MovimientoAbonoDTO;
import com.sc.sicanet.stp_ws.entities.Prestamos;
import com.sc.sicanet.stp_ws.entities.PrestamosTdc;
import com.sc.sicanet.stp_ws.models.AbonoResponse;
import com.sc.sicanet.stp_ws.services.AbonosService;
import com.sc.sicanet.stp_ws.services.BitacoraService;
import com.sc.sicanet.stp_ws.services.PrestamosService;
import com.sc.sicanet.stp_ws.utils.CatalogoDevolucion;
import feign.FeignException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;

@Service
public class AbonosServiceImpl
implements AbonosService {
    @Autowired
    private PrestamosFeignClient prestamosClient;
    @Autowired
    private PrestamosTdcFeignClient prestamosTDCClient;
    @Autowired
    private ApiTDCFeignClient apiTDCClient;
    @Autowired
    private BitacoraService bitacoraService;
    @Value(value="${config.password.apitdc}")
    private String password_api_tdc;
    final PrestamosService prestamosService;

    public AbonosServiceImpl(PrestamosService prestamosService) {
        this.prestamosService = prestamosService;
    }

    public Optional<AbonoResponse> postAbono(AbonoRequestDTO abonoRequestDTO) {
        AbonoResponse abonoResponse = new AbonoResponse();
        System.out.println("Consumiendo servicio de abonos -> " + abonoRequestDTO.getCuentaBeneficiario());
        Prestamos prestamo_sofom = this.prestamosClient.postAbono(abonoRequestDTO.getCuentaBeneficiario());
        PrestamosTdc prestamo_tdc = this.prestamosTDCClient.postAbono(abonoRequestDTO.getCuentaBeneficiario());
        if (prestamo_sofom.getControl() != null) {
            System.out.println("control -> " + prestamo_sofom.getControl());
        } else {
            abonoResponse = prestamo_tdc.getAccount_id() != null ? this.realizarAbonoTDC(prestamo_tdc, abonoRequestDTO) : new AbonoResponse("devolver", CatalogoDevolucion.CUENTA_INEXISTENTE.getCodigo(), HttpStatusCode.valueOf((int)400));
        }
        this.bitacoraService.insertarBitacora(abonoResponse, abonoRequestDTO);
        return Optional.of(abonoResponse);
    }

    private AbonoResponse realizarAbonoTDC(PrestamosTdc prestamo_tdc, AbonoRequestDTO abonoRequestDTO) {
        try {
            MovimientoAbonoDTO abono = new MovimientoAbonoDTO(prestamo_tdc.getAccount_id(), abonoRequestDTO.getMonto(), 16.0, "T", 1, 1, "referencia", "referencia", "STP WEB", 0);
            AuthResponseDTO auth = this.apiTDCClient.auth(new AuthRequestDTO(this.password_api_tdc));
            AbonoResponseDTO abono_response = this.apiTDCClient.postAbono(abono, "Bearer " + auth.getResponse());
            System.out.println("abono_response -> " + abono_response.getEstatus());
            return new AbonoResponse("confirmar", HttpStatusCode.valueOf((int)200));
        }
        catch (FeignException.BadRequest | FeignException.NotFound e) {
            return new AbonoResponse("devolver", CatalogoDevolucion.CUENTA_INEXISTENTE.getCodigo(), HttpStatusCode.valueOf((int)400));
        }
    }
}

