/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.stp_ws.controllers.ejemplo;

import com.sc.sicanet.stp_ws.entities.ejemplo.PldPaises;
import com.sc.sicanet.stp_ws.models.ejemplo.Uuid;
import com.sc.sicanet.stp_ws.services.ejemplo.PldPaisesService;
import com.sc.sicanet.stp_ws.services.ejemplo.UuidService;
import com.sc.sicanet.stp_ws.utils.CryptoHanler;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/paises"})
public class PldPaisesController {
    @Value(value="${config.crypto.alias}")
    private String alias;
    @Value(value="${config.crypto.password}")
    private String password;
    private final PldPaisesService service;
    private final UuidService uuidService;

    public PldPaisesController(PldPaisesService service, UuidService uuidService) {
        this.service = service;
        this.uuidService = uuidService;
    }

    @GetMapping
    public ResponseEntity<List<PldPaises>> getMethodName() {
        CryptoHanler ch = new CryptoHanler();
        try {
            String cadena = ch.sign("||hola|as||", this.password, this.alias);
            System.out.println("cadena ->" + cadena);
            return ResponseEntity.ok((Object)this.service.findAll());
        }
        catch (Exception e) {
            System.out.println("Errorrrr: " + String.valueOf(e));
            return ResponseEntity.badRequest().build();
        }
    }

    @GetMapping(value={"uuid"})
    public ResponseEntity<Uuid> getUuid() {
        Optional uuidOptional = this.uuidService.getUuid();
        return uuidOptional.isPresent() ? ResponseEntity.ok((Object)((Uuid)uuidOptional.get())) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PldPaises> getMethodName(@RequestParam int id) {
        Optional pldPaisesOptional = this.service.findById(id);
        if (pldPaisesOptional.isPresent()) {
            return ResponseEntity.ok((Object)((PldPaises)pldPaisesOptional.orElseThrow()));
        }
        return ResponseEntity.notFound().build();
    }
}

