/*
 * Decompiled with CFR 0.152.
 */
package com.sicanet.solidez.solidez_queue_persons_back.config;

import com.sicanet.solidez.solidez_queue_persons_back.config.JwtUtils;
import com.sicanet.solidez.solidez_queue_persons_back.services.UserDetailService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthFilter
extends OncePerRequestFilter {
    private final JwtUtils jwtUtils;
    private final UserDetailService userDetailService;

    public JwtAuthFilter(JwtUtils jwtUtils, UserDetailService userDetailService) {
        this.jwtUtils = jwtUtils;
        this.userDetailService = userDetailService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer ") && this.jwtUtils.validateToken(token = authHeader.substring(7))) {
            String correo = this.jwtUtils.getUsernameForToken(token);
            UserDetails userDetails = this.userDetailService.loadUserByUsername(correo);
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

