/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.SocioeconomicosDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatDestinos;
import com.sc.sicanet.migracion_sicanet.entity.CatOrigenRecurso;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.PldCatPersonasRecursoDestino;
import com.sc.sicanet.migracion_sicanet.entity.PldCatPersonasRecursoOrigen;
import com.sc.sicanet.migracion_sicanet.repository.CatDestinoRecursoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatOrigenRecursoRepository;
import com.sc.sicanet.migracion_sicanet.repository.PersonaRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldCatPersonasRecursoDestinoRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldCatPersonasRecursoOrigenRepository;
import com.sc.sicanet.migracion_sicanet.service.SocioeconomicosService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocioeconomicosServiceImpl
implements SocioeconomicosService {
    @Autowired
    private PersonaRepository personaRepository;
    @Autowired
    private PldCatPersonasRecursoDestinoRepository pldCatPersonasRecursoDestinoRepository;
    @Autowired
    private PldCatPersonasRecursoOrigenRepository pldCatPersonasRecursoOrigenRepository;
    @Autowired
    private CatDestinoRecursoRepository catDestinoRecursoRepository;
    @Autowired
    private CatOrigenRecursoRepository catOrigenRecursoRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public PldCatPersonasRecursoDestino guardarDestinoRecurso(PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino) {
        return (PldCatPersonasRecursoDestino)this.pldCatPersonasRecursoDestinoRepository.save((Object)pldCatPersonasRecursoDestino);
    }

    public PldCatPersonasRecursoOrigen guardarOrigenRecurso(PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen) {
        return (PldCatPersonasRecursoOrigen)this.pldCatPersonasRecursoOrigenRepository.save((Object)pldCatPersonasRecursoOrigen);
    }

    public Optional<PldCatPersonasRecursoDestino> consultarRecursoDestino(Persona persona) {
        return this.pldCatPersonasRecursoDestinoRepository.findByPersonaAndEstatus(persona, "A");
    }

    public Optional<PldCatPersonasRecursoOrigen> consultarRecursoOrigen(Persona persona) {
        return this.pldCatPersonasRecursoOrigenRepository.findByPersonaAndEstatus(persona, "A");
    }

    public PldCatPersonasRecursoDestino convertirDatosDeRecursosDestino(SocioeconomicosDTO pldCatPersonasRecursoDestinoDTO, Persona persona) {
        Optional recursoDestinoExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional catDestinos = this.catDestinoRecursoRepository.findByDestino(pldCatPersonasRecursoDestinoDTO.getDestino_recurso());
        PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino = new PldCatPersonasRecursoDestino(fechaActual, catDestinos.isPresent() ? ((CatDestinos)catDestinos.get()).getPkCatDestino() : 0, "", 0, "API Migracion", "A", 1, "");
        pldCatPersonasRecursoDestino.setFechaControl(fechaActual);
        pldCatPersonasRecursoDestino.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && (recursoDestinoExistente = this.consultarRecursoDestino(persona)).isPresent()) {
            pldCatPersonasRecursoDestino.setPkPldCatPersonasRecursoDestino(((PldCatPersonasRecursoDestino)recursoDestinoExistente.get()).getPkPldCatPersonasRecursoDestino());
            pldCatPersonasRecursoDestino.setFechaControl(((PldCatPersonasRecursoDestino)recursoDestinoExistente.get()).getFechaControl());
            pldCatPersonasRecursoDestino.setFechaRegistro(((PldCatPersonasRecursoDestino)recursoDestinoExistente.get()).getFechaRegistro());
        }
        return pldCatPersonasRecursoDestino;
    }

    public PldCatPersonasRecursoOrigen convertirDatosDeRecursosOrigen(SocioeconomicosDTO pldCatPersonasRecursoOrigenDTO, Persona persona) {
        Optional recursoOrigenExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional catOrigenRecurso = this.catOrigenRecursoRepository.findByDescripcion(pldCatPersonasRecursoOrigenDTO.getOrigen_recurso());
        PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen = new PldCatPersonasRecursoOrigen(fechaActual, catOrigenRecurso.isPresent() ? ((CatOrigenRecurso)catOrigenRecurso.get()).getPkCatOrigenRecurso() : 0, "", 0, "API Migracion", "A", 1, "");
        pldCatPersonasRecursoOrigen.setFechaControl(fechaActual);
        pldCatPersonasRecursoOrigen.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && (recursoOrigenExistente = this.consultarRecursoOrigen(persona)).isPresent()) {
            pldCatPersonasRecursoOrigen.setPkPldCatPersonasRecursoOrigen(((PldCatPersonasRecursoOrigen)recursoOrigenExistente.get()).getPkPldCatPersonasRecursoOrigen());
            pldCatPersonasRecursoOrigen.setFechaControl(((PldCatPersonasRecursoOrigen)recursoOrigenExistente.get()).getFechaControl());
            pldCatPersonasRecursoOrigen.setFechaRegistro(((PldCatPersonasRecursoOrigen)recursoOrigenExistente.get()).getFechaRegistro());
        }
        return pldCatPersonasRecursoOrigen;
    }
}

