/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.PrestamosSolicitudesDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatBanxicoTiie;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoPrestamos;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoPrestamosPeriodos;
import com.sc.sicanet.migracion_sicanet.entity.ConfiguracionEmpresa;
import com.sc.sicanet.migracion_sicanet.entity.PrestamosSolicitudes;
import com.sc.sicanet.migracion_sicanet.entity.Socio;
import com.sc.sicanet.migracion_sicanet.repository.CatBanxicoTiieRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoPrestamosPeriodosRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoPrestamosRepository;
import com.sc.sicanet.migracion_sicanet.repository.ConfiguracionEmpresaRepository;
import com.sc.sicanet.migracion_sicanet.repository.PrestamosSolicitudesRepository;
import com.sc.sicanet.migracion_sicanet.service.PrestamosSolicitudesService;
import com.sc.sicanet.migracion_sicanet.utils.Funciones;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrestamosSolicitudesServiceImpl
implements PrestamosSolicitudesService {
    @Autowired
    private PrestamosSolicitudesRepository prestamosSolicitudesRepository;
    @Autowired
    private CatTipoPrestamosRepository catTipoPrestamosRepository;
    @Autowired
    private CatBanxicoTiieRepository catBanxicoTiieRepository;
    @Autowired
    private ConfiguracionEmpresaRepository configuracionEmpresaRepository;
    @Autowired
    private CatTipoPrestamosPeriodosRepository catTipoPrestamosPeriodosRepository;
    @Autowired
    private Funciones funciones;
    private static final int longitud_consecutivo = 7;
    @PersistenceContext
    private EntityManager entityManager;

    public PrestamosSolicitudes guardarPrestamosSolicitudes(PrestamosSolicitudes prestamosSolicitudes) {
        return (PrestamosSolicitudes)this.prestamosSolicitudesRepository.save((Object)prestamosSolicitudes);
    }

    public Optional<PrestamosSolicitudes> consultaPrestamosSolicitudes(Socio socio) {
        return this.prestamosSolicitudesRepository.findBySocio(socio);
    }

    public Optional<PrestamosSolicitudes> consultaSolicitudesByControlAndEstatus(String control_solicitud, String estatus) {
        return this.prestamosSolicitudesRepository.findByControlAndEstatus(control_solicitud, estatus);
    }

    public String controlSolicitud(LocalDate fechaSolicitud, int sucursal) {
        Object controlSolicitud = "";
        String fechaSolicitud_ = String.valueOf(fechaSolicitud.getYear()).substring(2, 4);
        int consecutivo = this.prestamosSolicitudesRepository.obtenerConsecutivo(fechaSolicitud.getYear(), sucursal);
        controlSolicitud = "0001";
        controlSolicitud = (String)controlSolicitud + "-SOL-";
        controlSolicitud = (String)controlSolicitud + fechaSolicitud_;
        controlSolicitud = (String)controlSolicitud + Funciones.LPAD((Object)consecutivo, (Object)"0", (int)5);
        return controlSolicitud;
    }

    private Map<String, Double> calcularTasas(Optional<CatTipoPrestamos> catTipoPrestamos, Optional<CatBanxicoTiie> tiie, Optional<ConfiguracionEmpresa> multiplicadorInteresMoratorio) {
        int multiplicador_tasa_normal = multiplicadorInteresMoratorio.map(ConfiguracionEmpresa::getMultiplicadorInteresMoratorio).orElse(0);
        Double porcentaje_anual_tiie = catTipoPrestamos.map(CatTipoPrestamos::getPorcentajeAnualTiie).orElse(0.0);
        Double valor_tiie = tiie.map(CatBanxicoTiie::getTasa).orElse(0.0);
        Double tasa_normal = valor_tiie == 0.0 ? catTipoPrestamos.map(CatTipoPrestamos::getIntn).orElse(0.0) : porcentaje_anual_tiie + valor_tiie;
        Double intm = tasa_normal * (double)multiplicador_tasa_normal;
        HashMap<String, Double> tasas = new HashMap<String, Double>();
        tasas.put("tasa_normal", tasa_normal);
        tasas.put("intm", intm);
        return tasas;
    }

    public PrestamosSolicitudes convertirDatosDePrestamosSolicitudes(PrestamosSolicitudesDTO prestamosSolicitudesDTO, Socio socio) {
        Optional prestamoSolicitudExistente;
        LocalDateTime fechaHoraActual = LocalDateTime.now();
        LocalDate fechaActual = LocalDate.now();
        Optional tiie = this.catBanxicoTiieRepository.findFirstByOrderByFechaDesc();
        Optional multiplicadorInteresMoratorio = this.configuracionEmpresaRepository.findFirstBy();
        Optional catTipoPrestamos = this.catTipoPrestamosRepository.findByPkTipoPrestamo(prestamosSolicitudesDTO.getTipo_solicitud());
        if (!catTipoPrestamos.isPresent()) {
            throw new IllegalArgumentException("Tipo De Pr\u00e9stamo No V\u00e1lido.");
        }
        int tipoSolicitud = prestamosSolicitudesDTO.getTipo_solicitud();
        if (tipoSolicitud == 10 || tipoSolicitud == 14) {
            throw new IllegalArgumentException("El Tipo De Pr\u00e9stamo Ingresado No Est\u00e1 Permitido.");
        }
        Optional periodicidad = Optional.empty();
        try {
            String acronimo = prestamosSolicitudesDTO.getPeriodicidad().trim().toUpperCase();
            periodicidad = this.catTipoPrestamosPeriodosRepository.findByFkTipoPrestamoAndAcronimoPeriodoAndEstatus(((CatTipoPrestamos)catTipoPrestamos.get()).getPkTipoPrestamo(), acronimo, "A");
        }
        catch (RuntimeException e) {
            System.out.println("erorr -> " + String.valueOf(e));
        }
        if (!periodicidad.isPresent()) {
            throw new IllegalArgumentException("Periodicidad No V\u00e1lida Para Este Tipo De Pr\u00e9stamo.");
        }
        String periodicidadCorrecta = ((CatTipoPrestamosPeriodos)periodicidad.get()).getAcronimoPeriodo();
        int numeroPagares = prestamosSolicitudesDTO.getPagares();
        if (numeroPagares < ((CatTipoPrestamosPeriodos)periodicidad.get()).getPlazoMinimo() || numeroPagares > ((CatTipoPrestamosPeriodos)periodicidad.get()).getPlazoMaximo()) {
            throw new IllegalArgumentException("El N\u00famero De Pagos Ingresado No Es V\u00e1lido.");
        }
        Double montoSolicitado = prestamosSolicitudesDTO.getMonto_solicitado();
        Double montoMinimo = catTipoPrestamos.map(CatTipoPrestamos::getMontoMinimo).orElse(0.0);
        Double montoMaximo = catTipoPrestamos.map(CatTipoPrestamos::getMontoMaximo).orElse(0.0);
        if (montoSolicitado < montoMinimo || montoSolicitado > montoMaximo) {
            throw new IllegalArgumentException("El Monto Solicitado No Es V\u00e1lido Para Este Tipo De Pr\u00e9stamo.");
        }
        Map tasas = this.calcularTasas(catTipoPrestamos, tiie, multiplicadorInteresMoratorio);
        Double tasa_normal = (Double)tasas.get("tasa_normal");
        Double intm = (Double)tasas.get("intm");
        String control = this.controlSolicitud(fechaActual, 1);
        Boolean es_promocion = catTipoPrestamos.map(ctp -> "S".equalsIgnoreCase(ctp.getPromocion())).orElse(false);
        int meses_promocion = es_promocion != false ? catTipoPrestamos.map(CatTipoPrestamos::getMesesPromocion).orElse(0) : 0;
        prestamosSolicitudesDTO.setInteres_normal(tasa_normal);
        prestamosSolicitudesDTO.setInteres_moratorio(intm);
        PrestamosSolicitudes prestamosSolicitudes = new PrestamosSolicitudes(fechaHoraActual, (java.util.Date)Date.valueOf("1990-01-01"), "I", "N", "N", "API MIGRACION", "P", (java.util.Date)Date.valueOf("1990-01-01"), (java.util.Date)Date.valueOf("1990-01-01"), (java.util.Date)Date.valueOf("1990-01-01"), (java.util.Date)Date.valueOf("1990-01-01"), (java.util.Date)Date.valueOf("1990-01-01"), 0, 0, 1, 0, 0, 0, 0, 0, 0, catTipoPrestamos.isPresent() ? ((CatTipoPrestamos)catTipoPrestamos.get()).getPkTipoPrestamo() : 0, Double.valueOf(0.0), montoSolicitado, Double.valueOf(0.0), Double.valueOf(0.0), prestamosSolicitudesDTO.getIncluir_iva(), 0, "", "", "", numeroPagares, 0, periodicidadCorrecta, "", Double.valueOf(0.0), "N", "", "", 1, prestamosSolicitudesDTO.getTipo_cobro(), Double.valueOf(0.0));
        prestamosSolicitudes.setFechaControl(fechaHoraActual);
        prestamosSolicitudes.setFechaRegistro(fechaHoraActual);
        prestamosSolicitudes.setFechaSolicitud(fechaActual);
        prestamosSolicitudes.setControl(control);
        if (prestamosSolicitudesDTO.getControl_solicitud() != null && !prestamosSolicitudesDTO.getControl_solicitud().isEmpty() && (prestamoSolicitudExistente = this.consultaSolicitudesByControlAndEstatus(prestamosSolicitudesDTO.getControl_solicitud(), "P")).isPresent()) {
            prestamosSolicitudes.setPkPrestamoSolicitud(((PrestamosSolicitudes)prestamoSolicitudExistente.get()).getPkPrestamoSolicitud());
            prestamosSolicitudes.setFechaControl(((PrestamosSolicitudes)prestamoSolicitudExistente.get()).getFechaControl());
            prestamosSolicitudes.setFechaRegistro(((PrestamosSolicitudes)prestamoSolicitudExistente.get()).getFechaRegistro());
            prestamosSolicitudes.setFechaSolicitud(((PrestamosSolicitudes)prestamoSolicitudExistente.get()).getFechaSolicitud());
            prestamosSolicitudes.setControl(((PrestamosSolicitudes)prestamoSolicitudExistente.get()).getControl());
        }
        return prestamosSolicitudes;
    }
}

