/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.entity.Prestamos;
import com.sc.sicanet.migracion_sicanet.repository.PrestamosRepository;
import com.sc.sicanet.migracion_sicanet.service.PrestamosService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PrestamosServiceImpl
implements PrestamosService {
    @PersistenceContext
    private EntityManager entityManager;
    private final PrestamosRepository repository;

    public PrestamosServiceImpl(PrestamosRepository repository) {
        this.repository = repository;
    }

    public List<Prestamos> findAll() {
        return (List)this.repository.findAll();
    }

    public Optional<Prestamos> findById(int id) {
        return this.repository.findById((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Prestamos> findByCuentaSTP(String cuentaSTP) {
        try {
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Prestamos.class);
            Root prestamos = query.from(Prestamos.class);
            Predicate predicate = cb.equal((Expression)prestamos.get("cuentaStp"), (Object)cuentaSTP);
            query.select((Selection)prestamos).where((Expression)predicate);
            Optional<Prestamos> prestamo = Optional.ofNullable((Prestamos)this.entityManager.createQuery(query).getSingleResult());
            System.out.println("prestamo -> " + String.valueOf(prestamo.get()));
            Optional<Prestamos> optional = prestamo;
            return optional;
        }
        catch (Exception e) {
            System.out.println("Error: " + String.valueOf(e));
            Optional<Prestamos> optional = Optional.empty();
            return optional;
        }
        finally {
            this.entityManager.close();
        }
    }
}

