/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.PersonaDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatEstadoCivil;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoEntidades;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.repository.CatEstadoCivilRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoEntidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.PersonaRepository;
import com.sc.sicanet.migracion_sicanet.service.PersonaService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonaServiceImpl
implements PersonaService {
    @Autowired
    private PersonaRepository personaRepository;
    @Autowired
    private CatGeoEntidadesRepository catGeoEntidadesRepository;
    @Autowired
    private CatEstadoCivilRepository catEstadoCivilRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Optional<Persona> consultaPersonas(Persona persona) {
        return persona.getTipoPersona().equals("F") ? this.personaRepository.findByCurp(persona.getCurp()) : this.personaRepository.findByRfc(persona.getRfc());
    }

    public Persona guardarPersonas(Persona persona) {
        return (Persona)this.personaRepository.save((Object)persona);
    }

    public Persona convertirADatosDePersona(PersonaDTO personaDTO) {
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional catGeoEntidades = this.catGeoEntidadesRepository.findByEntidad(personaDTO.getEntidad_nacimiento());
        Optional catEstadoCivil = this.catEstadoCivilRepository.findByPrefijoBuro(personaDTO.getEstado_civil());
        Persona persona = new Persona(fechaActual, personaDTO.getTipo_persona(), personaDTO.getNombre(), personaDTO.getApaterno(), personaDTO.getAmaterno(), catGeoEntidades.isPresent() ? ((CatGeoEntidades)catGeoEntidades.get()).getPkCatEntidad() : 0, personaDTO.getLugar_nacimiento(), personaDTO.getFecha_nacimiento(), personaDTO.getSexo(), personaDTO.getRfc(), personaDTO.getCurp(), catEstadoCivil.isPresent() ? ((CatEstadoCivil)catEstadoCivil.get()).getPrefijoBuro() : "", "", 0, "", "", "", "", 0, 0, 1, "API Migracion", "A", 1);
        persona.setFechaControl(fechaActual);
        persona.setFechaRegistro(fechaActual);
        Optional personaExistente = this.consultaPersonas(persona);
        if (!personaExistente.isEmpty()) {
            persona.setPkPersona(((Persona)personaExistente.get()).getPkPersona());
            persona.setFechaRegistro(((Persona)personaExistente.get()).getFechaRegistro());
            persona.setFechaControl(((Persona)personaExistente.get()).getFechaModificacion());
        }
        return persona;
    }
}

