/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.InformacionPepsDTO;
import com.sc.sicanet.migracion_sicanet.entity.InformacionPEPS;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.repository.InformacionPepsRepository;
import com.sc.sicanet.migracion_sicanet.service.InformacionPepsService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InformacionPepsServiceImpl
implements InformacionPepsService {
    @Autowired
    private InformacionPepsRepository informacionPepsRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public InformacionPEPS guardarInformacionPeps(InformacionPEPS informacionPEPS) {
        return (InformacionPEPS)this.informacionPepsRepository.save((Object)informacionPEPS);
    }

    public Optional<InformacionPEPS> consultarInformacionPEPS(Persona persona) {
        return this.informacionPepsRepository.findByPersonaAndEstatus(persona, "A");
    }

    private String convertirBooleanAValor(Boolean valor) {
        return Boolean.TRUE.equals(valor) ? "S" : "N";
    }

    public InformacionPEPS convertirDatosDeInformacionPeps(InformacionPepsDTO informacionPepsDTO, Persona persona) {
        Optional informacionPEPSExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        String nacional = this.convertirBooleanAValor(informacionPepsDTO.getPoliticamente_expuesta_nacional());
        String internacional = this.convertirBooleanAValor(informacionPepsDTO.getPoliticamente_expuesta_internacional());
        String relacion = this.convertirBooleanAValor(informacionPepsDTO.getRelacion_politicamente_expuesta());
        InformacionPEPS informacionPEPS = new InformacionPEPS(fechaActual, nacional, internacional, relacion, 0, "API Migraci\u00f3n", "A", 1, "");
        informacionPEPS.setFechaControl(fechaActual);
        informacionPEPS.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && (informacionPEPSExistente = this.consultarInformacionPEPS(persona)).isPresent()) {
            informacionPEPS.setPkPldCatPersonasPepsCuestionario(((InformacionPEPS)informacionPEPSExistente.get()).getPkPldCatPersonasPepsCuestionario());
            informacionPEPS.setFechaControl(((InformacionPEPS)informacionPEPSExistente.get()).getFechaControl());
            informacionPEPS.setFechaRegistro(((InformacionPEPS)informacionPEPSExistente.get()).getFechaRegistro());
        }
        return informacionPEPS;
    }
}

