/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.DomicilioDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoEntidades;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoLocalidades;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoMunicipios;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoAsentamiento;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoCasa;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoVialidad;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoViveZona;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoVivienda;
import com.sc.sicanet.migracion_sicanet.entity.CodigosPostales;
import com.sc.sicanet.migracion_sicanet.entity.Domicilio;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.PldPaises;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoEntidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoLocalidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoMunicipiosRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoAsentamientoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoCasaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoVialidadRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoViveZonaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoViviendaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CodigosPostalesRepository;
import com.sc.sicanet.migracion_sicanet.repository.DomicilioRepository;
import com.sc.sicanet.migracion_sicanet.repository.PersonaRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldPaisesRepository;
import com.sc.sicanet.migracion_sicanet.service.DomicilioService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DomicilioServiceImpl
implements DomicilioService {
    @Autowired
    private DomicilioRepository domicilioRepository;
    @Autowired
    private PersonaRepository personaRepository;
    @Autowired
    private PldPaisesRepository pldPaisesRepository;
    @Autowired
    private CatGeoEntidadesRepository catGeoEntidadesRepository;
    @Autowired
    private CatGeoLocalidadesRepository catGeoLocalidadesRepository;
    @Autowired
    private CatGeoMunicipiosRepository catGeoMunicipiosRepository;
    @Autowired
    private CatTipoViviendaRepository catTipoViviendaRepository;
    @Autowired
    private CatTipoCasaRepository catTipoCasaRepository;
    @Autowired
    private CatTipoViveZonaRepository catTipoViveZonaRepository;
    @Autowired
    private CatTipoAsentamientoRepository catTipoAsentamientoRepository;
    @Autowired
    private CatTipoVialidadRepository catTipoVialidadRepository;
    @Autowired
    private CodigosPostalesRepository codigosPostalesRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Optional<Domicilio> consultaDomicilio(Persona persona, String tipoDomicilio, String estatus, String dispositivo) {
        return this.domicilioRepository.findByPersonaAndTipoDomicilioAndEstatusAndDispositivo(persona, tipoDomicilio, estatus, dispositivo);
    }

    public Domicilio guardarDomicilio(Domicilio domicilio) {
        return (Domicilio)this.domicilioRepository.save((Object)domicilio);
    }

    public Domicilio convertirDatosDeDomicilio(DomicilioDTO domicilioDTO, Persona persona, boolean es_personal) {
        Optional domicilioExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional pldPaises = this.pldPaisesRepository.findByNombre(domicilioDTO.getPais());
        Optional catGeoEntidades = this.catGeoEntidadesRepository.findByEntidad(domicilioDTO.getEntidad());
        Optional catGeoMunicipios = this.catGeoMunicipiosRepository.findByMunicipioAndFkCatEntidad(domicilioDTO.getMunicipio(), ((CatGeoEntidades)catGeoEntidades.get()).getPkCatEntidad());
        Optional catGeoLocalidades = this.catGeoLocalidadesRepository.findByLocalidadAndFkCatMunicipioAndFkCatEntidad(domicilioDTO.getLocalidad(), ((CatGeoMunicipios)catGeoMunicipios.get()).getPkCatMunicipio(), ((CatGeoEntidades)catGeoEntidades.get()).getPkCatEntidad());
        Optional catTipoVivienda = this.catTipoViviendaRepository.findByDescripcion(domicilioDTO.getTipo_vivienda());
        Optional catTipoCasa = this.catTipoCasaRepository.findByTipoCasa(domicilioDTO.getTipo_casa());
        Optional catTipoViveZona = this.catTipoViveZonaRepository.findByDescripcion(domicilioDTO.getZona_residencia());
        Optional catTipoAsentamiento = this.catTipoAsentamientoRepository.findByDescripcion(domicilioDTO.getTipo_asentamiento());
        Optional catTipoVialidad = this.catTipoVialidadRepository.findByTipoVialidad(domicilioDTO.getTipo_vialidad());
        Optional codigosPostales = this.codigosPostalesRepository.findByCodigoPostalAndFkCatEntidadAndFkCatMunicipio(domicilioDTO.getCp(), ((CatGeoEntidades)catGeoEntidades.get()).getPkCatEntidad(), ((CatGeoMunicipios)catGeoMunicipios.get()).getPkCatMunicipio());
        String tipo_domicilio = es_personal ? "DP" : "DL";
        Domicilio domicilio = new Domicilio(fechaActual, catTipoVialidad.isPresent() ? ((CatTipoVialidad)catTipoVialidad.get()).getTipoVialidad() : "", domicilioDTO.getNombre_vialidad(), domicilioDTO.getNum_exterior(), domicilioDTO.getNum_interior(), "", "", "", catTipoCasa.isPresent() ? ((CatTipoCasa)catTipoCasa.get()).getTipoCasa() : "", domicilioDTO.getAntiguedad_domicilio(), codigosPostales.isPresent() ? ((CodigosPostales)codigosPostales.get()).getCodigoPostal() : "", catTipoAsentamiento.isPresent() ? ((CatTipoAsentamiento)catTipoAsentamiento.get()).getDescripcion() : "", domicilioDTO.getNombre_asentamiento(), tipo_domicilio, Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), "", catTipoViveZona.isPresent() ? ((CatTipoViveZona)catTipoViveZona.get()).getAcronimo() : "", catTipoVivienda.isPresent() ? ((CatTipoVivienda)catTipoVivienda.get()).getAcronimo() : "", "", 0, "API Migracion", "A", 1, catGeoEntidades.isPresent() ? ((CatGeoEntidades)catGeoEntidades.get()).getPkCatEntidad() : 0, catGeoMunicipios.isPresent() ? ((CatGeoMunicipios)catGeoMunicipios.get()).getPkCatMunicipio() : 0, catGeoLocalidades.isPresent() ? ((CatGeoLocalidades)catGeoLocalidades.get()).getPkCatLocalidad() : 0, pldPaises.isPresent() ? ((PldPaises)pldPaises.get()).getPkPais() : 0, "", domicilioDTO.getUuid());
        if (domicilioDTO.getUuid() == null || domicilioDTO.getUuid().isEmpty()) {
            domicilio.setUuid(UUID.randomUUID().toString());
        } else {
            domicilio.setUuid(domicilioDTO.getUuid());
        }
        domicilio.setFechaControl(fechaActual);
        domicilio.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && !(domicilioExistente = this.consultaDomicilio(persona, tipo_domicilio, "A", "Api Migracion")).isEmpty()) {
            domicilio.setPkDomicilio(((Domicilio)domicilioExistente.get()).getPkDomicilio());
            domicilio.setFechaControl(((Domicilio)domicilioExistente.get()).getFechaControl());
            domicilio.setFechaRegistro(((Domicilio)domicilioExistente.get()).getFechaRegistro());
        }
        return domicilio;
    }
}

