/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.response;

import com.sc.sicanet.migracion_sicanet.response.ErrorResponse;
import com.sc.sicanet.migracion_sicanet.response.StandardResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<List<ErrorResponse>> handleValidationExceptions(MethodArgumentNotValidException ex) {
        List errors = ex.getBindingResult().getAllErrors().stream().map(error -> new ErrorResponse(400, ((FieldError)error).getField(), error.getDefaultMessage())).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(errors);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<StandardResponse> handleGeneralException(Exception ex) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new StandardResponse(500, "Error interno del servidor: " + ex.getMessage(), null));
    }
}

