/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.Socio;
import com.sc.sicanet.migracion_sicanet.entity.Sucursal;
import com.sc.sicanet.migracion_sicanet.repository.SocioRepository;
import com.sc.sicanet.migracion_sicanet.repository.SucursalRepository;
import com.sc.sicanet.migracion_sicanet.service.SocioService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocioServiceImpl
implements SocioService {
    @Autowired
    private SocioRepository socioRepository;
    @Autowired
    private SucursalRepository sucursalRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Socio guardarSocio(Socio socio) {
        this.agregarDatos(socio);
        return (Socio)this.socioRepository.save(socio);
    }

    @Override
    public Map<String, String> recuperarSocio(Persona persona) {
        String referenciaSocio = "";
        Object nombreSocio = "";
        HashMap<String, String> socioRecuperado = new HashMap<String, String>();
        Optional<Socio> socio = this.socioRepository.findByPersona(persona);
        if (socio.isPresent()) {
            referenciaSocio = socio.get().getReferenciaSocio();
            nombreSocio = persona.getNombre() + " " + persona.getApellidoPaterno() + " " + persona.getApellidoMaterno();
            socioRecuperado.put("referenciaSocio", referenciaSocio);
            socioRecuperado.put("nombreSocio", (String)nombreSocio);
            return socioRecuperado;
        }
        return null;
    }

    @Override
    public Socio agregarDatos(Socio socio) {
        LocalDateTime fechaActual = LocalDateTime.now();
        LocalDate fechaAlta = LocalDate.now();
        Date fechaBaja = Date.valueOf("1900-01-01");
        socio.setFechaRegistro(fechaActual);
        socio.setFechaModificacion(fechaActual);
        socio.setRefenciaSocio("");
        socio.setNumeroSerieFiel("");
        socio.setEstatus("A");
        socio.setTipoSocio("A");
        socio.setFechaAlta(fechaAlta);
        socio.setFechaBaja(fechaBaja);
        socio.setDispositivo("API Migracion");
        socio.setObservacionEjecutivo("");
        socio.setNumeroIdentificacionFiscal("");
        socio.setSucursal(1);
        socio.setFkCatUsuario(1);
        socio.setRefenciaSocio(this.referenciaSocio(socio));
        return socio;
    }

    @Override
    public String referenciaSocio(Socio socio) {
        Object refenciaSocio = "";
        String consecutivo = "";
        Optional<Sucursal> sucursal = this.sucursalRepository.findByPkEmpresa(socio.getSucursal());
        if (sucursal.isPresent()) {
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Long.class);
            Root root = query.from(Socio.class);
            query.select((Selection)cb.count((Expression)root)).where((Expression)cb.equal((Expression)root.get("sucursal"), (Object)socio.getSucursal()));
            Long totalSocios = (Long)this.entityManager.createQuery(query).getSingleResult();
            consecutivo = String.format("%06d", totalSocios + 1L);
            refenciaSocio = sucursal.get().getPrefijo() + "-" + consecutivo;
        }
        return refenciaSocio;
    }
}

