export declare type Variable = string | number | boolean | Node | Node[];
export interface Options {
    node: Node;
    rootNode: Node;
    position?: number;
    nodeList?: Node[];
    parent?: XSLTContext;
    returnOnFirstMatch?: boolean;
    caseInsensitive?: boolean;
    variables?: Map<string, Variable>;
}
export declare class XSLTContext {
    node: Node;
    rootNode: Node;
    nodeList: Node[];
    position: number;
    parent?: XSLTContext;
    variables: Map<string, Variable>;
    returnOnFirstMatch: boolean;
    caseInsensitive: boolean;
    constructor({ node, rootNode, position, nodeList, parent, returnOnFirstMatch, caseInsensitive, variables }: Options);
    clone(node?: Node, rootNode?: Node, position?: number, nodeList?: Node[]): XSLTContext;
    contextSize(): number;
    setVariable(name: string, value: Variable): void;
    getVariable(name: string): Variable | undefined;
    eval(select: string, type?: number): import("xpath-ts").XPathResult;
    setNode(position: number): void;
    setReturnOnFirstMatch(returnOnFirstMatch: boolean): void;
    setCaseInsensitive(caseInsensitive: boolean): void;
}
