"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const install_1 = require("./install");
const dom_1 = require("./utils/dom");
const types_1 = require("./utils/types");
const xslt_1 = require("./xslt");
const xslt_context_1 = require("./xslt-context");
class XSLTProcessorImpl {
    constructor() {
        this.variables = new Map();
    }
    clearParameters() {
        this.variables.clear();
    }
    getParameter(_namespaceURI, localName) {
        return this.variables.get(localName);
    }
    importStylesheet(style) {
        if (types_1.isDocument(style)) {
            this.stylesheet = style.documentElement;
        }
        else {
            this.stylesheet = style;
        }
    }
    removeParameter(_namespaceURI, localName) {
        this.variables.delete(localName);
    }
    reset() {
        this.stylesheet = undefined;
    }
    setParameter(_namespaceURI, localName, value) {
        this.variables.set(localName, value);
    }
    transformToDocument(source) {
        if (this.stylesheet === undefined) {
            throw new Error('No XSL stylesheet was given');
        }
        const output = install_1.getDom().createDocument(null, null, null);
        const fragment = dom_1.domCreateDocumentFragment(output);
        const context = new xslt_context_1.XSLTContext({ node: source, rootNode: source, variables: this.variables });
        xslt_1.xsltProcessContext(context, this.stylesheet, this.stylesheet, fragment);
        output.appendChild(fragment);
        return output;
    }
    transformToFragment(source, document) {
        if (this.stylesheet === undefined) {
            throw new Error('No XSL stylesheet was given');
        }
        const output = dom_1.domCreateDocumentFragment(document);
        const context = new xslt_context_1.XSLTContext({ node: source, rootNode: source, variables: this.variables });
        xslt_1.xsltProcessContext(context, this.stylesheet, this.stylesheet, output);
        return output;
    }
}
exports.XSLTProcessorImpl = XSLTProcessorImpl;
//# sourceMappingURL=xslt-processor.js.map