"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const xpath_ts_1 = require("xpath-ts");
class XSLTContext {
    constructor({ node, rootNode, position = 0, nodeList = [node], parent, returnOnFirstMatch = false, caseInsensitive = false, variables = new Map() }) {
        this.node = node;
        this.rootNode = rootNode;
        this.parent = parent;
        this.nodeList = nodeList;
        this.position = position;
        this.variables = variables;
        this.returnOnFirstMatch = returnOnFirstMatch;
        this.caseInsensitive = caseInsensitive;
    }
    clone(node = this.node, rootNode = this.rootNode, position = this.position, nodeList = this.nodeList) {
        return new XSLTContext({
            node,
            rootNode,
            position,
            nodeList,
            parent: this
        });
    }
    contextSize() {
        return this.nodeList.length;
    }
    setVariable(name, value) {
        this.variables.set(name, value);
    }
    getVariable(name) {
        const value = this.variables.get(name);
        if (value !== undefined) {
            return value;
        }
        else if (this.parent !== undefined) {
            return this.parent.getVariable(name);
        }
        else {
            return undefined;
        }
    }
    eval(select, type = 0) {
        const evaluator = new xpath_ts_1.XPathEvaluator({
            vr: {
                getVariable: (ln) => {
                    const val = this.getVariable(ln);
                    if (val === undefined) {
                        return null;
                    }
                    else {
                        return xpath_ts_1.convertValue(val);
                    }
                }
            }
        });
        const expression = evaluator.createExpression(select, null);
        expression.context.virtualRoot = this.rootNode;
        const result = expression.evaluate(this.node, type, null);
        return result;
    }
    setNode(position) {
        this.node = this.nodeList[position];
        this.position = position;
    }
    setReturnOnFirstMatch(returnOnFirstMatch) {
        this.returnOnFirstMatch = returnOnFirstMatch;
    }
    setCaseInsensitive(caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }
}
exports.XSLTContext = XSLTContext;
//# sourceMappingURL=xslt-context.js.map