"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Wrapper around DOM methods so we can condense their invocations.
function domGetAttribute(node, name) {
    return node.getAttribute(name);
}
exports.domGetAttribute = domGetAttribute;
function domSetAttribute(node, name, value) {
    return node.setAttribute(name, value);
}
exports.domSetAttribute = domSetAttribute;
function domAppendChild(node, child) {
    return node.appendChild(child);
}
exports.domAppendChild = domAppendChild;
function domCreateTextNode(doc, text) {
    return doc.createTextNode(text);
}
exports.domCreateTextNode = domCreateTextNode;
function domCreateElement(doc, name) {
    return doc.createElement(name);
}
exports.domCreateElement = domCreateElement;
function domCreateCDATASection(doc, data) {
    return doc.createCDATASection(data);
}
exports.domCreateCDATASection = domCreateCDATASection;
function domCreateComment(doc, text) {
    return doc.createComment(text);
}
exports.domCreateComment = domCreateComment;
function domCreateDocumentFragment(doc) {
    return doc.createDocumentFragment();
}
exports.domCreateDocumentFragment = domCreateDocumentFragment;
//# sourceMappingURL=dom.js.map