"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
let _dom;
let _parser;
let _serializer;
function getParser() {
    if (_parser === undefined) {
        throw new Error('No DOM implementation was provided.');
    }
    return _parser;
}
exports.getParser = getParser;
function getSerializer() {
    if (_serializer === undefined) {
        throw new Error('No DOM implementation was provided.');
    }
    return _serializer;
}
exports.getSerializer = getSerializer;
function getDom() {
    if (_dom === undefined) {
        throw new Error('No DOM implementation was provided.');
    }
    return _dom;
}
exports.getDom = getDom;
function install(parser, serializer, dom) {
    _parser = parser;
    _serializer = serializer;
    _dom = dom;
}
exports.install = install;
//# sourceMappingURL=install.js.map