import { AVLTree } from './avl-tree';
export declare abstract class Expression {
    toString(): string;
    evaluate(_c: XPathContext): Expression;
    readonly string: XString;
    readonly number: XNumber;
    readonly bool: XBoolean;
    readonly nodeset: XNodeSet;
    readonly stringValue: string;
    readonly numberValue: number;
    readonly booleanValue: boolean;
    equals(_r: Expression): XBoolean;
    notequal(_r: Expression): XBoolean;
    lessthan(_r: Expression): XBoolean;
    greaterthan(_r: Expression): XBoolean;
    lessthanorequal(_r: Expression): XBoolean;
    greaterthanorequal(_r: Expression): XBoolean;
}
export declare class XBoolean extends Expression {
    static TRUE: XBoolean;
    static FALSE: XBoolean;
    b: boolean;
    constructor(b: any);
    toString(): string;
    evaluate(_c: XPathContext): this;
    readonly string: XString;
    readonly number: XNumber;
    readonly bool: this;
    readonly nodeset: XNodeSet;
    readonly stringValue: string;
    readonly numberValue: number;
    readonly booleanValue: boolean;
    not(): XBoolean;
    equals(r: Expression): XBoolean;
    notequal(r: Expression): XBoolean;
    lessthan(r: Expression): XBoolean;
    greaterthan(r: Expression): XBoolean;
    lessthanorequal(r: Expression): XBoolean;
    greaterthanorequal(r: Expression): XBoolean;
}
export declare class XNumber extends Expression {
    num: number;
    constructor(n: any);
    readonly numberFormat: RegExp;
    parse(s: string): number;
    toString(): string;
    evaluate(_c: XPathContext): this;
    readonly string: XString;
    readonly number: this;
    readonly bool: XBoolean;
    readonly nodeset: XNodeSet;
    readonly stringValue: string;
    readonly numberValue: number;
    readonly booleanValue: boolean;
    negate(): XNumber;
    equals(r: Expression): XBoolean;
    notequal(r: Expression): XBoolean;
    lessthan(r: Expression): XBoolean;
    greaterthan(r: Expression): XBoolean;
    lessthanorequal(r: Expression): XBoolean;
    greaterthanorequal(r: Expression): XBoolean;
    plus(r: XNumber): XNumber;
    minus(r: XNumber): XNumber;
    multiply(r: XNumber): XNumber;
    div(r: XNumber): XNumber;
    mod(r: XNumber): XNumber;
}
export declare class XString extends Expression {
    str: string;
    constructor(s: any);
    toString(): string;
    evaluate(_c: XPathContext): this;
    readonly string: this;
    readonly number: XNumber;
    readonly bool: XBoolean;
    readonly nodeset: XNodeSet;
    readonly stringValue: string;
    readonly numberValue: number;
    readonly booleanValue: boolean;
    equals(r: Expression): XBoolean;
    notequal(r: Expression): XBoolean;
    lessthan(r: Expression): XBoolean;
    greaterthan(r: Expression): XBoolean;
    lessthanorequal(r: Expression): XBoolean;
    greaterthanorequal(r: Expression): XBoolean;
}
export declare class XNodeSet extends Expression {
    static compareWith(o: Operator): (this: XNodeSet, r: Expression) => XBoolean;
    tree: AVLTree | null;
    nodes: Node[];
    size: number;
    constructor();
    toString(): string;
    evaluate(_c: XPathContext): this;
    readonly string: XString;
    readonly stringValue: string;
    readonly number: XNumber;
    readonly numberValue: number;
    readonly bool: XBoolean;
    readonly booleanValue: boolean;
    readonly nodeset: this;
    stringForNode(n: Node): string;
    stringForContainerNode(n: Node): string;
    buildTree(): AVLTree | null;
    first(): Node | null;
    add(n: Node): void;
    addArray(ns: Node[]): void;
    /**
     * Returns an array of the node set's contents in document order
     */
    toArray(): Node[];
    toArrayRec(t: AVLTree | null, a: Node[]): void;
    /**
     * Returns an array of the node set's contents in arbitrary order
     */
    toUnsortedArray(): Node[];
    compareWithString(r: XString, o: Operator): XBoolean;
    compareWithNumber(r: XNumber, o: Operator): XBoolean;
    compareWithBoolean(r: XBoolean, o: Operator): XBoolean;
    compareWithNodeSet(r: XNodeSet, o: Operator): XBoolean;
    equals: (this: XNodeSet, r: Expression) => XBoolean;
    notequal: (this: XNodeSet, r: Expression) => XBoolean;
    lessthan: (this: XNodeSet, r: Expression) => XBoolean;
    greaterthan: (this: XNodeSet, r: Expression) => XBoolean;
    lessthanorequal: (this: XNodeSet, r: Expression) => XBoolean;
    greaterthanorequal: (this: XNodeSet, r: Expression) => XBoolean;
    union(r: XNodeSet): XNodeSet;
}
export declare type FunctionType = (c: XPathContext, ...args: Expression[]) => Expression;
export interface FunctionResolver {
    getFunction(localName: string, namespace: string): FunctionType | undefined;
}
export interface VariableResolver {
    getVariable(ln: string, ns: string): Expression | null;
}
export interface NamespaceResolver {
    getNamespace(prefix: string, n: Node | null): string | null;
}
export declare class XPathContext {
    variableResolver: VariableResolver;
    namespaceResolver: NamespaceResolver;
    functionResolver: FunctionResolver;
    contextNode: Node;
    virtualRoot: Node | null;
    expressionContextNode: Node;
    isHtml: boolean;
    contextSize: number;
    contextPosition: number;
    allowAnyNamespaceForNoPrefix: boolean;
    caseInsensitive: boolean;
    constructor(vr: VariableResolver, nr: NamespaceResolver, fr: FunctionResolver);
    clone(): XPathContext & this;
    extend(newProps: {
        [P in keyof XPathContext]?: XPathContext[P];
    }): XPathContext;
}
export declare type Operator = (l: Expression, r: Expression) => XBoolean;
export declare class Operators {
    static equals(l: Expression, r: Expression): XBoolean;
    static notequal(l: Expression, r: Expression): XBoolean;
    static lessthan(l: Expression, r: Expression): XBoolean;
    static greaterthan(l: Expression, r: Expression): XBoolean;
    static lessthanorequal(l: Expression, r: Expression): XBoolean;
    static greaterthanorequal(l: Expression, r: Expression): XBoolean;
}
