import { NodeXPathNSResolver } from './node-x-path-ns-resolver';
import { XPathExpressionImpl } from './xpath-expression-impl';
import { XPathParser } from './xpath-parser';
import { FunctionResolver, NamespaceResolver, VariableResolver } from './xpath-types';
export declare class XPathEvaluatorImpl implements XPathEvaluator {
    functionResolver?: FunctionResolver;
    variableResolver?: VariableResolver;
    namespaceResolver?: NamespaceResolver;
    parser?: XPathParser;
    constructor({ fr, vr, p }: {
        fr?: FunctionResolver;
        vr?: VariableResolver;
        p?: XPathParser;
    });
    createExpression(e: string, r: XPathNSResolver | null): XPathExpressionImpl;
    createNSResolver(n?: Node): NodeXPathNSResolver;
    evaluate(expression: string, contextNode: Node, resolver: XPathNSResolver | null, type: number, result: XPathResult | null): import("./xpath-result-impl").XPathResultImpl;
}
