import { LocationPath } from './location-path';
import { Step } from './step';
import { Expression, XPathContext } from './xpath-types';
export declare class PathExpr extends Expression {
    static predicateMatches(pred: Expression, c: XPathContext): boolean;
    static applyLocationPath(locationPath: LocationPath | undefined, xpc: XPathContext, nodes: Node[]): Node[];
    static applyStep(step: Step, xpc: XPathContext, node: Node): Node[];
    static getRoot(xpc: XPathContext, nodes: Node[]): Node;
    static applySteps(steps: Step[], xpc: XPathContext, nodes: Node[]): Node[];
    static getOwnerElement(n: Attr): Element | null;
    static applyPredicates(predicates: Expression[], c: XPathContext, nodes: Node[]): Node[];
    static predicateString: (e: Expression) => string;
    static predicatesString: (es: Expression[]) => string;
    filter?: Expression;
    filterPredicates?: Expression[];
    locationPath?: LocationPath;
    constructor(filter: Expression | undefined, filterPreds: Expression[] | undefined, locpath: LocationPath | undefined);
    applyFilter(c: XPathContext, xpc: XPathContext): {
        nodes: Node[];
        nonNodes?: undefined;
    } | {
        nonNodes: Expression;
        nodes?: undefined;
    };
    evaluate(c: XPathContext): Expression;
    toString(): string;
}
