import { NamespaceResolverImpl } from './namespace-resolver';
import { VariableResolverImpl } from './variable-resolver';
import { XPath } from './xpath';
import { Expression, FunctionType, XBoolean, XNodeSet, XNumber, XString } from './xpath-types';
export declare function makeNSResolver(resolver: any): NamespaceResolverImpl;
/** Converts native JavaScript types to their XPath library equivalent */
export declare function convertValue(value: any): XString | XNumber | XBoolean | XNodeSet | null;
export declare function makeFunctionResolver(resolver: any): {
    getFunction(name: string, namespace: string): FunctionType | undefined;
};
export declare function makeVariableResolver(resolver: any): VariableResolverImpl;
export interface EvalOptions {
    [key: string]: any;
}
export declare function parse(xpath: string): {
    expression: XPath;
    evaluate(options?: EvalOptions | undefined): Expression;
    evaluateNumber(options?: EvalOptions | undefined): number;
    evaluateString(options?: EvalOptions | undefined): string;
    evaluateBoolean(options?: EvalOptions | undefined): boolean;
    evaluateNodeSet(options?: EvalOptions | undefined): XNodeSet;
    select(options?: EvalOptions | undefined): Node[];
    select1(options?: EvalOptions | undefined): Node;
};
