import { Expression, XBoolean, XNodeSet, XNumber, XPathContext, XString } from './xpath-types';
export declare class Functions {
    static last(c: XPathContext, ...args: Expression[]): XNumber;
    static position(c: XPathContext, ...args: Expression[]): XNumber;
    static count(c: XPathContext, ...args: Expression[]): XNumber;
    static id(c: XPathContext, ...args: Expression[]): XNodeSet;
    static localName(c: XPathContext, ...args: Expression[]): XString;
    static namespaceURI(c: XPathContext, ...args: Expression[]): XString;
    static name_(c: XPathContext, ...args: Expression[]): XString;
    static string(c: XPathContext, ...args: Expression[]): XString;
    static concat(c: XPathContext, ...args: Expression[]): XString;
    static startsWith(c: XPathContext, ...args: Expression[]): XBoolean;
    static contains(c: XPathContext, ...args: Expression[]): XBoolean;
    static substringBefore(c: XPathContext, ...args: Expression[]): XString;
    static substringAfter(c: XPathContext, ...args: Expression[]): XString;
    static substring(c: XPathContext, ...args: Expression[]): XString;
    static stringLength(c: XPathContext, ...args: Expression[]): XNumber;
    static normalizeSpace(c: XPathContext, ...args: Expression[]): XString;
    static translate(c: XPathContext, ...args: Expression[]): XString;
    static boolean_(c: XPathContext, ...args: Expression[]): XBoolean;
    static not(c: XPathContext, ...args: Expression[]): XBoolean;
    static true_(_c: XPathContext, ...args: Expression[]): XBoolean;
    static false_(_c: XPathContext, ...args: Expression[]): XBoolean;
    static lang(c: XPathContext, ...args: Expression[]): XBoolean;
    static number(c: XPathContext, ...args: Expression[]): XNumber;
    static sum(c: XPathContext, ...args: Expression[]): XNumber;
    static floor(c: XPathContext, ...args: Expression[]): XNumber;
    static ceiling(c: XPathContext, ...args: Expression[]): XNumber;
    static round(c: XPathContext, ...args: Expression[]): XNumber;
}
