import { XPathParser } from './xpath-parser';
import { XPathResultImpl } from './xpath-result-impl';
import { FunctionResolver, VariableResolver } from './xpath-types';
export declare function select1(e: string, doc?: Node): string | number | boolean | Node | Node[];
export declare function select(e: string, doc?: Node, single?: boolean): string | number | boolean | Node | Node[];
export declare function useNamespaces(mappings: {
    [key: string]: string | null;
}): (e: string, doc: Node, single?: boolean) => string | number | boolean | Node | Node[];
export declare function selectWithResolver(e: string, doc: Node | undefined, resolver: XPathNSResolver | null, single?: boolean): string | number | boolean | Node | Node[];
export declare function evaluate(expression: string, contextNode?: Node, resolver?: XPathNSResolver | null, type?: number, result?: XPathResult | null): XPathResultImpl;
export declare function installXPathSupport(doc: Document, { fr, vr, p }: {
    fr?: FunctionResolver;
    vr?: VariableResolver;
    p?: XPathParser;
}): Document & XPathEvaluator;
