"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const function_resolver_1 = require("./function-resolver");
const namespace_resolver_1 = require("./namespace-resolver");
const types_1 = require("./utils/types");
const variable_resolver_1 = require("./variable-resolver");
const xpath_parser_1 = require("./xpath-parser");
const xpath_result_impl_1 = require("./xpath-result-impl");
const xpath_types_1 = require("./xpath-types");
class XPathExpressionImpl {
    static getOwnerDocument(n) {
        return types_1.isDocument(n) ? n : n.ownerDocument;
    }
    static detectHtmlDom(n) {
        if (!n) {
            return false;
        }
        const doc = XPathExpressionImpl.getOwnerDocument(n);
        try {
            if (doc != null) {
                return doc.implementation.hasFeature('HTML', '2.0');
            }
            else {
                return true;
            }
        }
        catch (e) {
            return true;
        }
    }
    constructor(e, { vr = new variable_resolver_1.VariableResolverImpl(), nr = new namespace_resolver_1.NamespaceResolverImpl(), fr = new function_resolver_1.FunctionResolverImpl(), p = new xpath_parser_1.XPathParser() }) {
        this.xpath = p.parse(e);
        this.context = new xpath_types_1.XPathContext(vr, nr, fr);
    }
    evaluate(n, t, _res) {
        // Intentionaly make the node as defined.
        // If no node is provided then the library will fail in case of context aware expression.
        n = n;
        this.context.expressionContextNode = n;
        // backward compatibility - no reliable way to detect whether the DOM is HTML, but
        // this library has been using this method up until now, so we will continue to use it
        // ONLY when using an XPathExpression
        this.context.caseInsensitive = XPathExpressionImpl.detectHtmlDom(n);
        const result = this.xpath.evaluate(this.context);
        return new xpath_result_impl_1.XPathResultImpl(result, t);
    }
}
exports.XPathExpressionImpl = XPathExpressionImpl;
//# sourceMappingURL=xpath-expression-impl.js.map