"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const node_x_path_ns_resolver_1 = require("./node-x-path-ns-resolver");
const types_1 = require("./utils/types");
const xpath_exception_1 = require("./xpath-exception");
const xpath_expression_impl_1 = require("./xpath-expression-impl");
const xpath_ns_resolver_wrapper_1 = require("./xpath-ns-resolver-wrapper");
class XPathEvaluatorImpl {
    constructor({ fr, vr, p }) {
        this.functionResolver = fr;
        this.variableResolver = vr;
        this.parser = p;
    }
    createExpression(e, r) {
        try {
            return new xpath_expression_impl_1.XPathExpressionImpl(e, {
                fr: this.functionResolver,
                nr: r == null ? this.namespaceResolver : new xpath_ns_resolver_wrapper_1.XPathNSResolverWrapper(r),
                vr: this.variableResolver,
                p: this.parser
            });
        }
        catch (e) {
            throw new xpath_exception_1.XPathException(xpath_exception_1.XPathException.INVALID_EXPRESSION_ERR, e);
        }
    }
    createNSResolver(n) {
        return new node_x_path_ns_resolver_1.NodeXPathNSResolver(n);
    }
    evaluate(expression, contextNode, resolver, type, result) {
        if (type < 0 || type > 9) {
            throw {
                code: 0,
                toString() {
                    return 'Request type not supported';
                }
            };
        }
        if (resolver != null) {
            resolver = convertNSResolver(resolver);
        }
        const ex = this.createExpression(expression, resolver);
        return ex.evaluate(contextNode, type, result);
    }
}
exports.XPathEvaluatorImpl = XPathEvaluatorImpl;
function convertNSResolver(resolver) {
    if (resolver == null) {
        return {
            lookupNamespaceURI(_prefix) {
                return null;
            }
        };
    }
    else if (!types_1.isNSResolver(resolver)) {
        const pr = resolver;
        return {
            lookupNamespaceURI(prefix) {
                return pr(prefix);
            }
        };
    }
    else {
        return resolver;
    }
}
//# sourceMappingURL=xpath-evaluator.js.map