"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const xml_1 = require("./utils/xml");
const xpath_exception_1 = require("./xpath-exception");
const xpath_types_1 = require("./xpath-types");
class VariableReference extends xpath_types_1.Expression {
    constructor(v) {
        super();
        this.variable = v;
    }
    toString() {
        return '$' + this.variable;
    }
    evaluate(c) {
        const parts = xml_1.resolveQName(this.variable, c.namespaceResolver, c.contextNode, false);
        if (parts[0] == null) {
            throw new Error('Cannot resolve QName ' + this.variable);
        }
        const result = c.variableResolver.getVariable(parts[1], parts[0]);
        if (!result) {
            throw xpath_exception_1.XPathException.fromMessage('Undeclared variable: ' + this.toString());
        }
        return result;
    }
}
exports.VariableReference = VariableReference;
//# sourceMappingURL=variable-reference.js.map