"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./types");
function splitQName(qn) {
    const i = qn.indexOf(':');
    if (i === -1) {
        return [null, qn];
    }
    return [qn.substring(0, i), qn.substring(i + 1)];
}
exports.splitQName = splitQName;
function resolveQName(qn, nr, n, useDefault) {
    const parts = splitQName(qn);
    if (parts[0] != null) {
        parts[0] = nr.getNamespace(parts[0], n);
    }
    else {
        if (useDefault) {
            parts[0] = nr.getNamespace('', n);
            if (parts[0] == null) {
                parts[0] = '';
            }
        }
        else {
            parts[0] = '';
        }
    }
    return parts;
}
exports.resolveQName = resolveQName;
function getElementById(n, id) {
    // Note that this does not check the DTD to check for actual
    // attributes of type ID, so this may be a bit wrong.
    if (types_1.isElement(n)) {
        if (n.getAttribute('id') === id || n.getAttributeNS(null, 'id') === id) {
            return n;
        }
    }
    for (let m = n.firstChild; m != null; m = m.nextSibling) {
        const res = getElementById(m, id);
        if (res != null) {
            return res;
        }
    }
    return null;
}
exports.getElementById = getElementById;
//# sourceMappingURL=xml.js.map