"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class NotEqualOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        return this.lhs.evaluate(c).notequal(this.rhs.evaluate(c));
    }
    toString() {
        return '(' + this.lhs.toString() + ' != ' + this.rhs.toString() + ')';
    }
}
exports.NotEqualOperation = NotEqualOperation;
//# sourceMappingURL=not-equals-operation.js.map