"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class ModOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        return this.lhs.evaluate(c).number.mod(this.rhs.evaluate(c).number);
    }
    toString() {
        return '(' + this.lhs.toString() + ' mod ' + this.rhs.toString() + ')';
    }
}
exports.ModOperation = ModOperation;
//# sourceMappingURL=mod-operation.js.map