"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class LessThanOrEqualOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        return this.lhs.evaluate(c).lessthanorequal(this.rhs.evaluate(c));
    }
    toString() {
        return '(' + this.lhs.toString() + ' <= ' + this.rhs.toString() + ')';
    }
}
exports.LessThanOrEqualOperation = LessThanOrEqualOperation;
//# sourceMappingURL=less-than-or-equal-operation.js.map