"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class EqualsOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        return this.lhs.evaluate(c).equals(this.rhs.evaluate(c));
    }
    toString() {
        return '(' + this.lhs.toString() + ' = ' + this.rhs.toString() + ')';
    }
}
exports.EqualsOperation = EqualsOperation;
//# sourceMappingURL=equals-operation.js.map