"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class DivOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        return this.lhs.evaluate(c).number.div(this.rhs.evaluate(c).number);
    }
    toString() {
        return '(' + this.lhs.toString() + ' div ' + this.rhs.toString() + ')';
    }
}
exports.DivOperation = DivOperation;
//# sourceMappingURL=div-operation.js.map