"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class AndOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        const b = this.lhs.evaluate(c).bool;
        if (!b.booleanValue) {
            return b;
        }
        return this.rhs.evaluate(c).bool;
    }
    toString() {
        return '(' + this.lhs.toString() + ' and ' + this.rhs.toString() + ')';
    }
}
exports.AndOperation = AndOperation;
//# sourceMappingURL=and-operation.js.map