"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const xpath_namespace_1 = require("./xpath-namespace");
// tslint:disable:member-ordering
class NodeTest {
    constructor(type) {
        this.type = type;
    }
    static isNodeType(types) {
        return (n) => {
            return types.includes(n.nodeType) || (n.specified && types.includes(2)); // DOM4 support
        };
    }
    // create invariant node test for certain node types
    static makeNodeTypeTest(type, nodeTypes, stringVal) {
        return new class extends NodeTest {
            constructor() {
                super(type);
                this.matches = NodeTest.isNodeType(nodeTypes);
                this.toString = () => stringVal;
            }
        }();
    }
    static hasPrefix(node) {
        return node.prefix || (node.nodeName || node.tagName).indexOf(':') !== -1;
    }
    static nameSpaceMatches(prefix, xpc, n) {
        const nNamespace = n.namespaceURI || '';
        if (!prefix) {
            return !nNamespace || (xpc.allowAnyNamespaceForNoPrefix && !NodeTest.hasPrefix(n));
        }
        const ns = xpc.namespaceResolver.getNamespace(prefix, n);
        if (ns == null) {
            // throw new Error('Cannot resolve QName ' + prefix);
            return false;
        }
        return ns === nNamespace;
    }
    toString() {
        return '<unknown nodetest type>';
    }
    matches(_n, _xpc) {
        // tslint:disable-next-line:no-console
        console.warn('unknown node test type');
        return false;
    }
}
NodeTest.NAMETESTANY = 0;
NodeTest.NAMETESTPREFIXANY = 1;
NodeTest.NAMETESTQNAME = 2;
NodeTest.COMMENT = 3;
NodeTest.TEXT = 4;
NodeTest.PI = 5;
NodeTest.NODE = 6;
NodeTest.isElementOrAttribute = NodeTest.isNodeType([1, 2]);
NodeTest.localNameMatches = (localName, xpc, n) => {
    const nLocalName = n.localName || n.nodeName;
    return xpc.caseInsensitive ? localName.toLowerCase() === nLocalName.toLowerCase() : localName === nLocalName;
    // tslint:disable-next-line:semicolon
};
// tslint:disable-next-line:variable-name
NodeTest.NameTestPrefixAny = class extends NodeTest {
    constructor(prefix) {
        super(NodeTest.NAMETESTPREFIXANY);
        this.prefix = prefix;
    }
    matches(n, xpc) {
        return NodeTest.isElementOrAttribute(n) && NodeTest.nameSpaceMatches(this.prefix, xpc, n);
    }
    toString() {
        return this.prefix + ':*';
    }
};
// tslint:disable-next-line:variable-name
NodeTest.NameTestQName = class extends NodeTest {
    constructor(name) {
        super(NodeTest.NAMETESTQNAME);
        const nameParts = name.split(':');
        this.name = name;
        this.prefix = nameParts.length > 1 ? nameParts[0] : null;
        this.localName = nameParts[nameParts.length > 1 ? 1 : 0];
    }
    matches(n, xpc) {
        return (NodeTest.isNodeType([1, 2, xpath_namespace_1.XPathNamespace.XPATH_NAMESPACE_NODE])(n) &&
            NodeTest.nameSpaceMatches(this.prefix, xpc, n) &&
            NodeTest.localNameMatches(this.localName, xpc, n));
    }
    toString() {
        return this.name;
    }
};
// tslint:disable-next-line:variable-name
NodeTest.PITest = class extends NodeTest {
    constructor(name) {
        super(NodeTest.PI);
        this.name = name;
    }
    matches(n, _xpc) {
        return NodeTest.isNodeType([7])(n) && (n.target || n.nodeName) === this.name;
    }
    toString() {
        return `processing-instruction("${this.name}")`;
    }
};
// elements, attributes, namespaces
NodeTest.nameTestAny = NodeTest.makeNodeTypeTest(NodeTest.NAMETESTANY, [1, 2, xpath_namespace_1.XPathNamespace.XPATH_NAMESPACE_NODE], '*');
// text, cdata
NodeTest.textTest = NodeTest.makeNodeTypeTest(NodeTest.TEXT, [3, 4], 'text()');
NodeTest.commentTest = NodeTest.makeNodeTypeTest(NodeTest.COMMENT, [8], 'comment()');
// elements, attributes, text, cdata, PIs, comments, document nodes
NodeTest.nodeTest = NodeTest.makeNodeTypeTest(NodeTest.NODE, [1, 2, 3, 4, 7, 8, 9], 'node()');
NodeTest.anyPiTest = NodeTest.makeNodeTypeTest(NodeTest.PI, [7], 'processing-instruction()');
exports.NodeTest = NodeTest;
//# sourceMappingURL=node-test.js.map