"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const functions_1 = require("./functions");
const xml_1 = require("./utils/xml");
class FunctionResolverImpl {
    static getFunctionFromContext(qName, context) {
        const parts = xml_1.resolveQName(qName, context.namespaceResolver, context.contextNode, false);
        if (parts[0] === null) {
            throw new Error('Cannot resolve QName ' + name);
        }
        return context.functionResolver.getFunction(parts[1], parts[0]);
    }
    constructor() {
        this.functions = {};
        this.addStandardFunctions();
    }
    addStandardFunctions() {
        this.functions['{}last'] = functions_1.Functions.last;
        this.functions['{}position'] = functions_1.Functions.position;
        this.functions['{}count'] = functions_1.Functions.count;
        this.functions['{}id'] = functions_1.Functions.id;
        this.functions['{}local-name'] = functions_1.Functions.localName;
        this.functions['{}namespace-uri'] = functions_1.Functions.namespaceURI;
        this.functions['{}name'] = functions_1.Functions.name_;
        this.functions['{}string'] = functions_1.Functions.string;
        this.functions['{}concat'] = functions_1.Functions.concat;
        this.functions['{}starts-with'] = functions_1.Functions.startsWith;
        this.functions['{}contains'] = functions_1.Functions.contains;
        this.functions['{}substring-before'] = functions_1.Functions.substringBefore;
        this.functions['{}substring-after'] = functions_1.Functions.substringAfter;
        this.functions['{}substring'] = functions_1.Functions.substring;
        this.functions['{}string-length'] = functions_1.Functions.stringLength;
        this.functions['{}normalize-space'] = functions_1.Functions.normalizeSpace;
        this.functions['{}translate'] = functions_1.Functions.translate;
        this.functions['{}boolean'] = functions_1.Functions.boolean_;
        this.functions['{}not'] = functions_1.Functions.not;
        this.functions['{}true'] = functions_1.Functions.true_;
        this.functions['{}false'] = functions_1.Functions.false_;
        this.functions['{}lang'] = functions_1.Functions.lang;
        this.functions['{}number'] = functions_1.Functions.number;
        this.functions['{}sum'] = functions_1.Functions.sum;
        this.functions['{}floor'] = functions_1.Functions.floor;
        this.functions['{}ceiling'] = functions_1.Functions.ceiling;
        this.functions['{}round'] = functions_1.Functions.round;
    }
    addFunction(ns, ln, f) {
        this.functions['{' + ns + '}' + ln] = f;
    }
    getFunction(localName, namespace) {
        return this.functions['{' + namespace + '}' + localName];
    }
}
exports.FunctionResolverImpl = FunctionResolverImpl;
//# sourceMappingURL=function-resolver.js.map