"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const xpath_evaluator_1 = require("./xpath-evaluator");
const xpath_result_impl_1 = require("./xpath-result-impl");
const defaultEvaluator = new xpath_evaluator_1.XPathEvaluatorImpl({});
function select1(e, doc) {
    return select(e, doc, true);
}
exports.select1 = select1;
function select(e, doc, single = false) {
    return selectWithResolver(e, doc, null, single);
}
exports.select = select;
function useNamespaces(mappings) {
    const resolver = {
        mappings: mappings || {},
        lookupNamespaceURI(prefix) {
            return this.mappings[prefix] !== undefined ? this.mappings[prefix] : null;
        }
    };
    return (e, doc, single = false) => {
        return selectWithResolver(e, doc, resolver, single);
    };
}
exports.useNamespaces = useNamespaces;
function selectWithResolver(e, doc, resolver, single = false) {
    const result = evaluate(e, doc, resolver, xpath_result_impl_1.XPathResultImpl.ANY_TYPE, null);
    if (result.resultType === xpath_result_impl_1.XPathResultImpl.STRING_TYPE) {
        return result.stringValue;
    }
    else if (result.resultType === xpath_result_impl_1.XPathResultImpl.NUMBER_TYPE) {
        return result.numberValue;
    }
    else if (result.resultType === xpath_result_impl_1.XPathResultImpl.BOOLEAN_TYPE) {
        return result.booleanValue;
    }
    else {
        if (single) {
            return result.nodes[0];
        }
        return result.nodes;
    }
}
exports.selectWithResolver = selectWithResolver;
function evaluate(expression, contextNode, resolver, type = 0, result) {
    return defaultEvaluator.evaluate(expression, contextNode, resolver ? resolver : null, type, result ? result : null);
}
exports.evaluate = evaluate;
function installXPathSupport(doc, { fr, vr, p }) {
    const evaluator = new xpath_evaluator_1.XPathEvaluatorImpl({ fr, vr, p });
    doc.createExpression = evaluator.createExpression;
    doc.createNSResolver = evaluator.createNSResolver;
    doc.evaluate = evaluator.evaluate;
    return doc;
}
exports.installXPathSupport = installXPathSupport;
//# sourceMappingURL=api.js.map