import './types';
export declare function isDocumentFragment(node: Node | null): node is DocumentFragment;
export declare function isDocument(node: Node | null): node is Document;
export declare function isText(node: Node | null): node is Text;
export declare function isAttr(node: Node | null): node is Attr;
export declare function isElement(node: Node | null): node is Element;
export declare function isProcessingInstruction(node: Node | null): node is ProcessingInstruction;
export declare function isComment(node: Node | null): node is Comment;
export declare function isCDATASection(node: Node | null): node is CDATASection;
export declare function isDocumentType(node: Node | null): node is DocumentType;
export declare function isEntityReference(node: Node | null): node is EntityReference;
export declare function isCharacterData(node: Node | null): node is CharacterData;
export declare function copy(src: Record<string, any>, dest: Record<string, any>): void;
export declare function asChildNode<T extends Node>(node: T): T & ChildNode;
export declare function asHTMLElement<T extends Element>(node: T): T & HTMLElement;
