import { ElementAttributes, Locator, NSMap } from '../types';
export interface Attribute {
    localName?: string;
    locator?: Locator;
    qName: string;
    uri?: string;
    value: string;
    offset: number;
}
export declare class ElementAttributesImpl implements ElementAttributes {
    [index: number]: Attribute;
    tagName: string;
    prefix: string;
    localName: string;
    uri: string;
    closed: boolean;
    currentNSMap: NSMap;
    localNSMap: NSMap;
    length: number;
    setTagName(tagName: string): void;
    add(qName: string, value: string, offset: number): void;
    getLocalName(i: number): string | undefined;
    getLocator(i: number): Locator | undefined;
    getQName(i: number): string;
    getURI(i: number): string | undefined;
    getValue(i: number): string;
}
