import './types';
import { DummyElement } from './dummy/dummy-element';
export declare class ElementImpl extends DummyElement {
    _nsMap: Record<string, string>;
    tagName: string;
    attributes: NamedNodeMap;
    localName: string;
    constructor();
    hasAttribute(name: string): boolean;
    getAttribute(name: string): string | null;
    getAttributeNode(name: string): Attr | null;
    setAttribute(name: string, value: string): void;
    removeAttribute(name: string): void;
    appendChild<T extends Node>(newChild: T): T;
    setAttributeNode(newAttr: Attr): Attr | null;
    setAttributeNodeNS(newAttr: Attr): Attr | null;
    removeAttributeNode(attr: Attr): Attr;
    removeAttributeNS(namespaceURI: string, localName: string): void;
    hasAttributeNS(namespaceURI: string, localName: string): boolean;
    getAttributeNS(namespaceURI: string, localName: string): string;
    setAttributeNS(namespaceURI: string, qualifiedName: string, value: string): void;
    getAttributeNodeNS(namespaceURI: string, localName: string): Attr | null;
    getElementsByTagName(tagName: string): any;
    getElementsByTagNameNS(namespaceURI: string, localName: string): any;
    readonly outerHTML: string;
}
