declare function copy(src: Record<string, any>, dest: Record<string, any>): void;
declare const htmlns = "http://www.w3.org/1999/xhtml";
declare const NodeType: {
    ELEMENT_NODE: number;
    ATTRIBUTE_NODE: number;
    TEXT_NODE: number;
    CDATA_SECTION_NODE: number;
    ENTITY_REFERENCE_NODE: number;
    ENTITY_NODE: number;
    PROCESSING_INSTRUCTION_NODE: number;
    COMMENT_NODE: number;
    DOCUMENT_NODE: number;
    DOCUMENT_TYPE_NODE: number;
    DOCUMENT_FRAGMENT_NODE: number;
    NOTATION_NODE: number;
};
declare var ExceptionCode: {};
declare var ExceptionMessage: {};
declare var INDEX_SIZE_ERR: number;
declare var DOMSTRING_SIZE_ERR: number;
declare var HIERARCHY_REQUEST_ERR: number;
declare var WRONG_DOCUMENT_ERR: number;
declare var INVALID_CHARACTER_ERR: number;
declare var NO_DATA_ALLOWED_ERR: number;
declare var NO_MODIFICATION_ALLOWED_ERR: number;
declare var NOT_FOUND_ERR: number;
declare var NOT_SUPPORTED_ERR: number;
declare var INUSE_ATTRIBUTE_ERR: number;
declare var INVALID_STATE_ERR: number;
declare var SYNTAX_ERR: number;
declare var INVALID_MODIFICATION_ERR: number;
declare var NAMESPACE_ERR: number;
declare var INVALID_ACCESS_ERR: number;
declare class DOMException extends Error {
    constructor(code: number, message?: Error);
}
/**
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-536297177
 * The NodeList interface provides the abstraction of an ordered collection of nodes,
 * without defining or constraining how this collection is implemented. NodeList objects in the DOM are live.
 * The items in the NodeList are accessible via an integral index, starting from 0.
 */
declare class NodeList extends Array<Node> {
    /**
     * The number of nodes in the list. The range of valid child node indices is 0 to length-1 inclusive.
     * @standard level1
     */
    length: number;
    /**
     * Returns the indexth item in the collection.
     * If index is greater than or equal to the number of nodes in the list, this returns null.
     *
     * @standard level1
     * @param index  unsigned long
     *   Index into the collection.
     * @return Node
     * 	The node at the indexth position in the NodeList, or null if that is not a valid index.
     */
    item(index: number): Node;
    toString(isHTML: boolean, nodeFilter: any): string;
}
declare class LiveNodeList extends NodeList {
    _node: Node;
    _refresh: any;
    constructor(node: Node, refresh: any);
    item(i: number): Node;
    private static _updateLiveList;
}
/**
 *
 * Objects implementing the NamedNodeMap interface are used to represent collections of nodes
 * that can be accessed by name. Note that NamedNodeMap does not inherit from NodeList;
 * NamedNodeMaps are not maintained in any particular order. Objects contained in an object
 * implementing NamedNodeMap may also be accessed by an ordinal index, but this is simply to
 * allow convenient enumeration of the contents of a NamedNodeMap, and does not imply that
 * the DOM specifies an order to these Nodes.
 *
 * NamedNodeMap objects in the DOM are live.
 * used for attributes or DocumentType entities
 */
declare class NamedNodeMap {
    length: number;
    getNamedItem(key: string): any;
    setNamedItem(attr: any): any;
    setNamedItemNS(attr: any): any;
    removeNamedItem(key: any): any;
    removeNamedItemNS(namespaceURI: any, localName: any): any;
    getNamedItemNS(namespaceURI: any, localName: any): any;
    private static _findNodeIndex;
    private static _addNamedNode;
    private static _removeNamedNode;
}
/**
 * @see http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-102161490
 */
declare function DOMImplementation(/* Object */ features: any): void;
/**
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-1950641247
 */
declare function Node(): void;
declare function _xmlEncoder(c: any): string;
/**
 * @param callback return true for continue,false for break
 * @return boolean true: break visit;
 */
declare function _visitNode(node: any, callback: any): true | undefined;
declare function Document(): void;
declare function _onAddAttribute(doc: any, el: any, newAttr: any): void;
declare function _onRemoveAttribute(doc: any, el: any, newAttr: any, remove: any): void;
declare function _onUpdateChild(doc: any, el: any, newChild: any): void;
/**
 * attributes;
 * children;
 *
 * writeable properties:
 * nodeValue,Attr:value,CharacterData:data
 * prefix
 */
declare function _removeChild(parentNode: any, child: any): any;
/**
 * preformance key(refChild == null)
 */
declare function _insertBefore(parentNode: any, newChild: any, nextChild: any): any;
declare function _appendSingleChild(parentNode: any, newChild: any): any;
declare function Element(): void;
declare function Attr(): void;
declare function CharacterData(): void;
declare function Text(): void;
declare function Comment(): void;
declare function CDATASection(): void;
declare function DocumentType(): void;
declare function Notation(): void;
declare function Entity(): void;
declare function EntityReference(): void;
declare function DocumentFragment(): void;
declare function ProcessingInstruction(): void;
declare function XMLSerializer(): void;
declare function nodeSerializeToString(isHtml: any, nodeFilter: any): string;
declare function needNamespaceDefine(node: any, isHTML: any, visibleNamespaces: any): boolean;
declare function serializeToString(node: any, buf: any, isHTML: any, nodeFilter: any, visibleNamespaces: any): any;
declare function importNode(doc: any, node: any, deep: any): any;
declare function cloneNode(doc: any, node: any, deep: any): any;
declare function __set__(object: any, key: any, value: any): void;
