export interface DOMParserOptions {
    locator: any;
    domBuilder?: DOMHandler;
    errorHandler?: any;
    xmlns?: Record<string, string>;
}
export declare class DOMParser {
    options: DOMParserOptions;
    constructor(options?: DOMParserOptions);
    parseFromString(source: string, mimeType: string): Document;
}
export declare class DOMHandler {
    cdata: boolean;
    doc: Document;
    locator: any;
    currentElement: Element | null;
    constructor();
    startDocument(): void;
    startElement(namespaceURI: string, localName: string, qName: string, attrs: NamedNodeMap): void;
    endElement(namespaceURI: string, localName: string, qName: string): void;
    startPrefixMapping(prefix: string, uri: string): void;
    endPrefixMapping(prefix: string): void;
    processingInstruction(target: string, data: string): void;
    ignorableWhitespace(ch: string, start: number, length: number): void;
    characters(chars: string, start: number, length: number): void;
    skippedEntity(name: string): void;
    endDocument(): void;
    setDocumentLocator(locator: any): void;
    comment(chars: string, start: number, length: number): void;
    startCDATA(): void;
    endCDATA(): void;
    startDTD(name: string, publicId: string, systemId: string): void;
    warning(error: string): void;
    error(error: string): void;
    fatalError(error: string): void;
}
export { XMLSerializer } from './dom';
export { DOMImplementation } from './dom';
export declare function isElement(e: Node | undefined | null): e is Element;
