import './types';
import { AttrImpl } from './attr';
import { CDATASectionImpl } from './cdata-section';
import { CommentImpl } from './comment';
import { DocumentFragmentImpl } from './document-fragment';
import { DummyDocument } from './dummy/dummy-document';
import { ElementImpl } from './element';
import { EntityReferenceImpl } from './entity-reference';
import { ProcessingInstructionImpl } from './processing-instruction';
import { TextImpl } from './text';
export declare class DocumentImpl extends DummyDocument {
    implementation: DOMImplementation;
    doctype: DocumentType | null;
    documentURI: string;
    documentElement: HTMLElement;
    _inc: number;
    constructor();
    insertBefore<T extends Node>(newChild: T, refChild: Node | null): T;
    removeChild<T extends Node>(oldChild: T): T;
    importNode<T extends Node>(importedNode: T, deep: boolean): T;
    getElementById(id: string): null;
    getElementsByTagName(tagName: string): any;
    getElementsByTagNameNS(namespaceURI: string, localName: string): any;
    createElement(tagName: string): ElementImpl;
    createDocumentFragment(): DocumentFragmentImpl;
    createTextNode(data: string): TextImpl;
    createComment(data: string): CommentImpl;
    createCDATASection(data: string): CDATASectionImpl;
    createProcessingInstruction(target: string, data: string): ProcessingInstructionImpl;
    createAttribute(name: string): AttrImpl;
    createEntityReference(name: string): EntityReferenceImpl;
    createElementNS(namespaceURI: string, qualifiedName: string): any;
    createAttributeNS(namespaceURI: string, qualifiedName: string): AttrImpl;
}
