import './types';
import { Mutable, MutableChildNode, MutableNode } from './types';
/**
 * @param callback return true for continue,false for break
 * @return boolean true: break visit;
 */
export declare function _visitNode(n: Node, callback: (node: Node) => boolean | undefined | void): true | undefined;
export declare function _onAddAttribute(doc: Document, el: Element, newAttr: Attr): void;
export declare function _onRemoveAttribute(doc: Document, el: Element, newAttr: Attr, _remove?: any): void;
export declare function _onUpdateChild(doc: Document | null, el: Node, newChild?: ChildNode): void;
/**
 * attributes;
 * children;
 *
 * writeable properties:
 * nodeValue,Attr:value,CharacterData:data
 * prefix
 */
export declare function _removeChild<T extends Node>(parentNode: MutableNode, child: T): T;
/**
 * preformance key(refChild == null)
 */
export declare function _insertBefore<T extends MutableChildNode>(parentNode: Mutable<Node & ParentNode>, newChild: T, nextChild: MutableChildNode | null): T;
export declare function _appendSingleChild<T extends MutableChildNode>(parentNode: Mutable<Node & ParentNode>, newChild: T): T;
export declare function importNode<T extends Node>(doc: Document, node: T, deep: boolean): T;
