"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const node_types_1 = require("./node-types");
function isDocumentFragment(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.DOCUMENT_FRAGMENT_NODE;
}
exports.isDocumentFragment = isDocumentFragment;
function isDocument(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.DOCUMENT_NODE;
}
exports.isDocument = isDocument;
function isText(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.TEXT_NODE;
}
exports.isText = isText;
function isAttr(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.ATTRIBUTE_NODE;
}
exports.isAttr = isAttr;
function isElement(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.ELEMENT_NODE;
}
exports.isElement = isElement;
function isProcessingInstruction(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.PROCESSING_INSTRUCTION_NODE;
}
exports.isProcessingInstruction = isProcessingInstruction;
function isComment(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.COMMENT_NODE;
}
exports.isComment = isComment;
function isCDATASection(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.CDATA_SECTION_NODE;
}
exports.isCDATASection = isCDATASection;
function isDocumentType(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.DOCUMENT_TYPE_NODE;
}
exports.isDocumentType = isDocumentType;
function isEntityReference(node) {
    return node != null && node.nodeType === node_types_1.NodeTypeTS.ENTITY_REFERENCE_NODE;
}
exports.isEntityReference = isEntityReference;
function isCharacterData(node) {
    return (node != null &&
        (node.nodeType === node_types_1.NodeTypeTS.TEXT_NODE ||
            node.nodeType === node_types_1.NodeTypeTS.CDATA_SECTION_NODE ||
            node.nodeType === node_types_1.NodeTypeTS.COMMENT_NODE ||
            node.nodeType === node_types_1.NodeTypeTS.PROCESSING_INSTRUCTION_NODE));
}
exports.isCharacterData = isCharacterData;
function copy(src, dest) {
    for (const field of Object.keys(src)) {
        dest[field] = src[field];
    }
}
exports.copy = copy;
function asChildNode(node) {
    return node;
}
exports.asChildNode = asChildNode;
function asHTMLElement(node) {
    return node;
}
exports.asHTMLElement = asHTMLElement;
//# sourceMappingURL=utils.js.map