"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dummy_text_1 = require("./dummy/dummy-text");
const node_types_1 = require("./node-types");
class TextImpl extends dummy_text_1.DummyText {
    constructor() {
        super();
        this.nodeName = '#text';
        this.nodeType = node_types_1.NodeTypeTS.TEXT_NODE;
    }
    splitText(offset) {
        let text = this.data;
        const newText = text.substring(offset);
        text = text.substring(0, offset);
        this.data = this.nodeValue = text;
        this.length = text.length;
        const newNode = this.ownerDocument.createTextNode(newText);
        if (this.parentNode) {
            this.parentNode.insertBefore(newNode, this.nextSibling);
        }
        return newNode;
    }
}
exports.TextImpl = TextImpl;
//# sourceMappingURL=text.js.map