"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const htmlEntity = __importStar(require("../entities"));
const dom_handler_1 = require("./dom-handler");
const sax_1 = require("./sax");
class DOMParserImpl {
    constructor(options) {
        this.options = options || { locator: { lineNumber: 0, columnNumber: 0 } };
    }
    parseFromString(source, mimeType = '') {
        const options = this.options;
        const sax = new sax_1.XMLReader();
        const domBuilder = options.domBuilder || new dom_handler_1.DOMHandlerImpl(); // contentHandler and LexicalHandler
        const errorHandler = options.errorHandler;
        const locator = options.locator;
        const defaultNSMap = options.xmlns || {};
        const isHTML = /\/x?html?$/.test(mimeType); // mimeType.toLowerCase().indexOf('html') > -1;
        const entityMap = isHTML ? htmlEntity.entityMap : { lt: '<', gt: '>', amp: '&', quot: '"', apos: `'` };
        if (locator) {
            domBuilder.setDocumentLocator(locator);
        }
        sax.errorHandler = this.buildErrorHandler(errorHandler, domBuilder, locator);
        sax.domBuilder = options.domBuilder || domBuilder;
        if (isHTML) {
            defaultNSMap[''] = 'http://www.w3.org/1999/xhtml';
        }
        defaultNSMap.xml = defaultNSMap.xml || 'http://www.w3.org/XML/1998/namespace';
        if (source) {
            sax.parse(source, defaultNSMap, entityMap);
        }
        else {
            sax.errorHandler.error('invalid doc source');
        }
        return domBuilder.doc;
    }
    buildErrorHandler(errorImpl, domBuilder, locator = { lineNumber: 0, columnNumber: 0 }) {
        if (!errorImpl) {
            if (domBuilder instanceof dom_handler_1.DOMHandlerImpl) {
                return domBuilder;
            }
        }
        const errorHandler = {};
        function build(key) {
            let fn = errorImpl && errorImpl[key];
            if (!fn && typeof errorImpl === 'function') {
                if (errorImpl.length === 2) {
                    fn = (msg) => {
                        if (typeof errorImpl === 'function') {
                            errorImpl(key, msg);
                        }
                    };
                }
                else {
                    fn = errorImpl;
                }
            }
            if (fn) {
                errorHandler[key] = (msg) => {
                    fn('[xmldom ' + key + ']\t' + msg + _locator(locator));
                };
            }
            else {
                errorHandler[key] = (_msg) => {
                    // empty
                };
            }
        }
        build('warning');
        build('error');
        build('fatalError');
        return errorHandler;
    }
}
exports.DOMParserImpl = DOMParserImpl;
function _locator(l) {
    if (l) {
        return '\n@' + (l.systemId || '') + '#[line:' + l.lineNumber + ',col:' + l.columnNumber + ']';
    }
}
//# sourceMappingURL=dom-parser.js.map