"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
class DOMParser {
    constructor(options) {
        this.options = options || { locator: {} };
    }
    parseFromString(source, mimeType) {
        var options = this.options;
        var sax = new sax_1.XMLReader();
        var domBuilder = options.domBuilder || new DOMHandler(); //contentHandler and LexicalHandler
        var errorHandler = options.errorHandler;
        var locator = options.locator;
        var defaultNSMap = options.xmlns || {};
        var isHTML = /\/x?html?$/.test(mimeType); //mimeType.toLowerCase().indexOf('html') > -1;
        var entityMap = isHTML ? htmlEntity.entityMap : { lt: '<', gt: '>', amp: '&', quot: '"', apos: "'" };
        if (locator) {
            domBuilder.setDocumentLocator(locator);
        }
        sax.errorHandler = buildErrorHandler(errorHandler, domBuilder, locator);
        sax.domBuilder = options.domBuilder || domBuilder;
        if (isHTML) {
            defaultNSMap[''] = 'http://www.w3.org/1999/xhtml';
        }
        defaultNSMap.xml = defaultNSMap.xml || 'http://www.w3.org/XML/1998/namespace';
        if (source) {
            sax.parse(source, defaultNSMap, entityMap);
        }
        else {
            sax.errorHandler.error('invalid doc source');
        }
        return domBuilder.doc;
    }
}
exports.DOMParser = DOMParser;
class DOMHandler {
    constructor() {
        this.cdata = false;
        this.currentElement = null;
    }
    startDocument() {
        this.doc = new dom_1.DOMImplementation().createDocument(null, null, null);
        if (this.locator) {
            this.doc.documentURI = this.locator.systemId;
        }
    }
    startElement(namespaceURI, localName, qName, attrs) {
        const doc = this.doc;
        const el = doc.createElementNS(namespaceURI, qName || localName);
        const len = attrs.length;
        appendElement(this, el);
        this.currentElement = el;
        this.locator && position(this.locator, el);
        for (var i = 0; i < len; i++) {
            const namespaceURI = attrs.getURI(i);
            const value = attrs.getValue(i);
            const qName = attrs.getQName(i);
            const attr = doc.createAttributeNS(namespaceURI, qName);
            this.locator && position(attrs.getLocator(i), attr);
            attr.value = attr.nodeValue = value;
            el.setAttributeNode(attr);
        }
    }
    endElement(namespaceURI, localName, qName) {
        var current = this.currentElement;
        if (current === null) {
            throw new Error('No open element');
        }
        // const tagName = current.tagName;
        if (!isElement(current.parentNode)) {
            throw new Error('Node is not element');
        }
        this.currentElement = current.parentNode;
    }
    startPrefixMapping(prefix, uri) { }
    endPrefixMapping(prefix) { }
    processingInstruction(target, data) {
        var ins = this.doc.createProcessingInstruction(target, data);
        this.locator && position(this.locator, ins);
        appendElement(this, ins);
    }
    ignorableWhitespace(ch, start, length) { }
    characters(chars, start, length) {
        chars.substr(start, length);
        //console.log(chars)
        if (chars) {
            let charNode;
            if (this.cdata) {
                charNode = this.doc.createCDATASection(chars);
            }
            else {
                charNode = this.doc.createTextNode(chars);
            }
            if (this.currentElement) {
                this.currentElement.appendChild(charNode);
            }
            else if (/^\s*$/.test(chars)) {
                this.doc.appendChild(charNode);
                //process xml
            }
            this.locator && position(this.locator, charNode);
        }
    }
    skippedEntity(name) { }
    endDocument() {
        this.doc.normalize();
    }
    setDocumentLocator(locator) {
        if ((this.locator = locator)) {
            // && !('lineNumber' in locator)){
            locator.lineNumber = 0;
        }
    }
    //LexicalHandler
    comment(chars, start, length) {
        chars.substr(start, length);
        var comm = this.doc.createComment(chars);
        this.locator && position(this.locator, comm);
        appendElement(this, comm);
    }
    startCDATA() {
        //used in characters() methods
        this.cdata = true;
    }
    endCDATA() {
        this.cdata = false;
    }
    startDTD(name, publicId, systemId) {
        var impl = this.doc.implementation;
        if (impl && impl.createDocumentType) {
            var dt = impl.createDocumentType(name, publicId, systemId);
            this.locator && position(this.locator, dt);
            appendElement(this, dt);
        }
    }
    warning(error) {
        console.warn('[xmldom warning]\t' + error, _locator(this.locator));
    }
    error(error) {
        console.error('[xmldom error]\t' + error, _locator(this.locator));
    }
    fatalError(error) {
        console.error('[xmldom fatalError]\t' + error, _locator(this.locator));
        throw error;
    }
}
exports.DOMHandler = DOMHandler;
function buildErrorHandler(errorImpl, domBuilder, locator) {
    if (!errorImpl) {
        if (domBuilder instanceof DOMHandler) {
            return domBuilder;
        }
        errorImpl = domBuilder;
    }
    var errorHandler = {};
    var isCallback = errorImpl instanceof Function;
    locator = locator || {};
    function build(key) {
        var fn = errorImpl[key];
        if (!fn && isCallback) {
            fn =
                errorImpl.length == 2
                    ? function (msg) {
                        errorImpl(key, msg);
                    }
                    : errorImpl;
        }
        errorHandler[key] =
            (fn &&
                function (msg) {
                    fn('[xmldom ' + key + ']\t' + msg + _locator(locator));
                }) ||
                function () { };
    }
    build('warning');
    build('error');
    build('fatalError');
    return errorHandler;
}
function position(locator, node) {
    node.lineNumber = locator.lineNumber;
    node.columnNumber = locator.columnNumber;
}
/**
 * @see org.xml.sax.ContentHandler#startDocument
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ContentHandler.html
 */
function _locator(l) {
    if (l) {
        return '\n@' + (l.systemId || '') + '#[line:' + l.lineNumber + ',col:' + l.columnNumber + ']';
    }
}
function _toString(chars, start, length) {
    return chars.substr(start, length);
}
/*
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/LexicalHandler.html
 * used method of org.xml.sax.ext.LexicalHandler:
 *  #comment(chars, start, length)
 *  #startCDATA()
 *  #endCDATA()
 *  #startDTD(name, publicId, systemId)
 *
 *
 * IGNORED method of org.xml.sax.ext.LexicalHandler:
 *  #endDTD()
 *  #startEntity(name)
 *  #endEntity(name)
 *
 *
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/DeclHandler.html
 * IGNORED method of org.xml.sax.ext.DeclHandler
 * 	#attributeDecl(eName, aName, type, mode, value)
 *  #elementDecl(name, model)
 *  #externalEntityDecl(name, publicId, systemId)
 *  #internalEntityDecl(name, value)
 * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/EntityResolver2.html
 * IGNORED method of org.xml.sax.EntityResolver2
 *  #resolveEntity(String name,String publicId,String baseURI,String systemId)
 *  #resolveEntity(publicId, systemId)
 *  #getExternalSubset(name, baseURI)
 * @link http://www.saxproject.org/apidoc/org/xml/sax/DTDHandler.html
 * IGNORED method of org.xml.sax.DTDHandler
 *  #notationDecl(name, publicId, systemId) {};
 *  #unparsedEntityDecl(name, publicId, systemId, notationName) {};
 */
'endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl'.replace(/\w+/g, function (key) {
    DOMHandler.prototype[key] = function () {
        return null;
    };
});
/* Private static helpers treated below as private instance methods, so don't need to add these to the public API; we might use a Relator to also get rid of non-standard public properties */
function appendElement(hander, node) {
    if (!hander.currentElement) {
        hander.doc.appendChild(node);
    }
    else {
        hander.currentElement.appendChild(node);
    }
} //appendChild and setAttributeNS are preformance key
//if(typeof require == 'function'){
const htmlEntity = __importStar(require("./entities"));
const sax_1 = require("./sax");
const dom_1 = require("./dom");
var dom_2 = require("./dom");
exports.XMLSerializer = dom_2.XMLSerializer;
var dom_3 = require("./dom");
exports.DOMImplementation = dom_3.DOMImplementation;
//}
// fixme: move
function isElement(e) {
    return e != null && e.nodeType === 1; // Node.ELEMENT_NODE;
}
exports.isElement = isElement;
//# sourceMappingURL=dom-parser.js.map