"use strict";
/*
 * DOM Level 2
 * Object DOMException
 * @see http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html
 */
Object.defineProperty(exports, "__esModule", { value: true });
class DOMExceptionImpl extends Error {
    constructor(code, message) {
        super();
        this.INDEX_SIZE_ERR = DOMExceptionImpl.INDEX_SIZE_ERR;
        this.DOMSTRING_SIZE_ERR = DOMExceptionImpl.DOMSTRING_SIZE_ERR;
        this.HIERARCHY_REQUEST_ERR = DOMExceptionImpl.HIERARCHY_REQUEST_ERR;
        this.WRONG_DOCUMENT_ERR = DOMExceptionImpl.WRONG_DOCUMENT_ERR;
        this.INVALID_CHARACTER_ERR = DOMExceptionImpl.INVALID_CHARACTER_ERR;
        this.NO_DATA_ALLOWED_ERR = DOMExceptionImpl.NO_DATA_ALLOWED_ERR;
        this.NO_MODIFICATION_ALLOWED_ERR = DOMExceptionImpl.NO_MODIFICATION_ALLOWED_ERR;
        this.NOT_FOUND_ERR = DOMExceptionImpl.NOT_FOUND_ERR;
        this.NOT_SUPPORTED_ERR = DOMExceptionImpl.NOT_SUPPORTED_ERR;
        this.INUSE_ATTRIBUTE_ERR = DOMExceptionImpl.INUSE_ATTRIBUTE_ERR;
        // level2
        this.INVALID_STATE_ERR = DOMExceptionImpl.INVALID_STATE_ERR;
        this.SYNTAX_ERR = DOMExceptionImpl.SYNTAX_ERR;
        this.INVALID_MODIFICATION_ERR = DOMExceptionImpl.INVALID_MODIFICATION_ERR;
        this.NAMESPACE_ERR = DOMExceptionImpl.NAMESPACE_ERR;
        this.INVALID_ACCESS_ERR = DOMExceptionImpl.INVALID_ACCESS_ERR;
        this.VALIDATION_ERR = DOMExceptionImpl.VALIDATION_ERR;
        this.TYPE_MISMATCH_ERR = DOMExceptionImpl.TYPE_MISMATCH_ERR;
        this.SECURITY_ERR = DOMExceptionImpl.SECURITY_ERR;
        this.NETWORK_ERR = DOMExceptionImpl.NETWORK_ERR;
        this.ABORT_ERR = DOMExceptionImpl.ABORT_ERR;
        this.URL_MISMATCH_ERR = DOMExceptionImpl.URL_MISMATCH_ERR;
        this.QUOTA_EXCEEDED_ERR = DOMExceptionImpl.QUOTA_EXCEEDED_ERR;
        this.TIMEOUT_ERR = DOMExceptionImpl.TIMEOUT_ERR;
        this.INVALID_NODE_TYPE_ERR = DOMExceptionImpl.INVALID_NODE_TYPE_ERR;
        this.DATA_CLONE_ERR = DOMExceptionImpl.DATA_CLONE_ERR;
        this.code = code;
        if (message === undefined) {
            message = this.translateMessage(code);
        }
    }
    translateMessage(code) {
        switch (code) {
            case DOMExceptionImpl.INDEX_SIZE_ERR:
                return 'Index size error';
            case DOMExceptionImpl.DOMSTRING_SIZE_ERR:
                return 'DOMString size error';
            case DOMExceptionImpl.HIERARCHY_REQUEST_ERR:
                return 'Hierarchy request error';
            case DOMExceptionImpl.WRONG_DOCUMENT_ERR:
                return 'Wrong document';
            case DOMExceptionImpl.INVALID_CHARACTER_ERR:
                return 'Invalid character';
            case DOMExceptionImpl.NO_DATA_ALLOWED_ERR:
                return 'No data allowed';
            case DOMExceptionImpl.NO_MODIFICATION_ALLOWED_ERR:
                return 'No modification allowed';
            case DOMExceptionImpl.NOT_FOUND_ERR:
                return 'Not found';
            case DOMExceptionImpl.NOT_SUPPORTED_ERR:
                return 'Not supported';
            case DOMExceptionImpl.INUSE_ATTRIBUTE_ERR:
                return 'Attribute in use';
            // level2
            case DOMExceptionImpl.INVALID_STATE_ERR:
                return 'Invalid state';
            case DOMExceptionImpl.SYNTAX_ERR:
                return 'Syntax error';
            case DOMExceptionImpl.INVALID_MODIFICATION_ERR:
                return 'Invalid modification';
            case DOMExceptionImpl.NAMESPACE_ERR:
                return 'Invalid namespace';
            case DOMExceptionImpl.INVALID_ACCESS_ERR:
                return 'Invalid access';
            case DOMExceptionImpl.VALIDATION_ERR:
                return 'Validation error';
            case DOMExceptionImpl.TYPE_MISMATCH_ERR:
                return 'The type of the object does not match the expected type';
            case DOMExceptionImpl.SECURITY_ERR:
                return 'The operation is insecure';
            case DOMExceptionImpl.NETWORK_ERR:
                return 'A network error occurred';
            case DOMExceptionImpl.ABORT_ERR:
                return 'A network error occurred';
            case DOMExceptionImpl.URL_MISMATCH_ERR:
                return 'The given URL does not match another URL';
            case DOMExceptionImpl.QUOTA_EXCEEDED_ERR:
                return 'The quota has been exceeded';
            case DOMExceptionImpl.TIMEOUT_ERR:
                return 'The quota has been exceeded';
            case DOMExceptionImpl.INVALID_NODE_TYPE_ERR:
                return 'The node is incorrect or has an incorrect ancestor for this operation';
            case DOMExceptionImpl.DATA_CLONE_ERR:
                return 'The object can not be cloned';
        }
    }
}
DOMExceptionImpl.INDEX_SIZE_ERR = 1;
DOMExceptionImpl.DOMSTRING_SIZE_ERR = 2;
DOMExceptionImpl.HIERARCHY_REQUEST_ERR = 3;
DOMExceptionImpl.WRONG_DOCUMENT_ERR = 4;
DOMExceptionImpl.INVALID_CHARACTER_ERR = 5;
DOMExceptionImpl.NO_DATA_ALLOWED_ERR = 6;
DOMExceptionImpl.NO_MODIFICATION_ALLOWED_ERR = 7;
DOMExceptionImpl.NOT_FOUND_ERR = 8;
DOMExceptionImpl.NOT_SUPPORTED_ERR = 9;
DOMExceptionImpl.INUSE_ATTRIBUTE_ERR = 10;
DOMExceptionImpl.INVALID_STATE_ERR = 11;
DOMExceptionImpl.SYNTAX_ERR = 12;
DOMExceptionImpl.INVALID_MODIFICATION_ERR = 13;
DOMExceptionImpl.NAMESPACE_ERR = 14;
DOMExceptionImpl.INVALID_ACCESS_ERR = 15;
DOMExceptionImpl.VALIDATION_ERR = 16;
DOMExceptionImpl.TYPE_MISMATCH_ERR = 17;
DOMExceptionImpl.SECURITY_ERR = 18;
DOMExceptionImpl.NETWORK_ERR = 19;
DOMExceptionImpl.ABORT_ERR = 20;
DOMExceptionImpl.URL_MISMATCH_ERR = 21;
DOMExceptionImpl.QUOTA_EXCEEDED_ERR = 22;
DOMExceptionImpl.TIMEOUT_ERR = 23;
DOMExceptionImpl.INVALID_NODE_TYPE_ERR = 24;
DOMExceptionImpl.DATA_CLONE_ERR = 25;
exports.DOMExceptionImpl = DOMExceptionImpl;
//# sourceMappingURL=dom-exception.js.map