"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const dom_exception_1 = require("./dom-exception");
const dummy_character_data_1 = require("./dummy/dummy-character-data");
const node_list_1 = require("./node-list");
class CharacterDataImpl extends dummy_character_data_1.DummyCharacterData {
    constructor() {
        super(...arguments);
        this._data = '';
        this.length = 0;
    }
    get data() {
        return this._data;
    }
    set data(data) {
        // notify observers
        this.queueMutation({
            type: 'characterData',
            target: this,
            addedNodes: new node_list_1.NodeListImpl(),
            removedNodes: new node_list_1.NodeListImpl(),
            previousSibling: null,
            nextSibling: null,
            attributeName: null,
            attributeNamespace: null,
            oldValue: this._data,
        });
        this._data = data;
    }
    substringData(offset, count) {
        return this.data.substring(offset, offset + count);
    }
    appendData(text) {
        text = this.data + text;
        this.nodeValue = this.data = text;
        this.length = text.length;
    }
    insertData(offset, text) {
        this.replaceData(offset, 0, text);
    }
    appendChild(_newChild) {
        throw new dom_exception_1.DOMExceptionImpl(dom_exception_1.DOMExceptionImpl.HIERARCHY_REQUEST_ERR);
    }
    deleteData(offset, count) {
        this.replaceData(offset, count, '');
    }
    replaceData(offset, count, text) {
        const start = this.data.substring(0, offset);
        const end = this.data.substring(offset + count);
        text = start + text + end;
        this.nodeValue = this.data = text;
        this.length = text.length;
    }
}
exports.CharacterDataImpl = CharacterDataImpl;
//# sourceMappingURL=character-data.js.map